// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/** Defines the data type of a field in a search index. */
public final class SearchFieldDataType extends ExpandableStringEnum<SearchFieldDataType> {

    /** Indicates that a field contains a string. */
    public static final SearchFieldDataType STRING = fromString("Edm.String");

    /** Indicates that a field contains a 32-bit signed integer. */
    public static final SearchFieldDataType INT32 = fromString("Edm.Int32");

    /** Indicates that a field contains a 64-bit signed integer. */
    public static final SearchFieldDataType INT64 = fromString("Edm.Int64");

    /** Indicates that a field contains an IEEE double-precision floating point number. */
    public static final SearchFieldDataType DOUBLE = fromString("Edm.Double");

    /** Indicates that a field contains a Boolean value (true or false). */
    public static final SearchFieldDataType BOOLEAN = fromString("Edm.Boolean");

    /** Indicates that a field contains a date/time value, including timezone information. */
    public static final SearchFieldDataType DATE_TIME_OFFSET = fromString("Edm.DateTimeOffset");

    /** Indicates that a field contains a geo-location in terms of longitude and latitude. */
    public static final SearchFieldDataType GEOGRAPHY_POINT = fromString("Edm.GeographyPoint");

    /** Indicates that a field contains one or more complex objects that in turn have sub-fields of other types. */
    public static final SearchFieldDataType COMPLEX = fromString("Edm.ComplexType");

    /**
     * Indicates that a field contains a single-precision floating point number. This is only valid when used with
     * Collection(Edm.Single).
     */
    public static final SearchFieldDataType SINGLE = fromString("Edm.Single");

    /**
     * Creates a new instance of SearchFieldDataType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SearchFieldDataType() {}

    /**
     * Creates or finds a SearchFieldDataType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SearchFieldDataType.
     */
    public static SearchFieldDataType fromString(String name) {
        return fromString(name, SearchFieldDataType.class);
    }

    /**
     * Gets known SearchFieldDataType values.
     *
     * @return known SearchFieldDataType values.
     */
    public static Collection<SearchFieldDataType> values() {
        return values(SearchFieldDataType.class);
    }

    /**
     * Returns a collection of a specific SearchFieldDataType.
     *
     * @param dataType the corresponding SearchFieldDataType
     * @return a Collection of the corresponding SearchFieldDataType
     */
    public static SearchFieldDataType collection(SearchFieldDataType dataType) {
        return fromString(String.format("Collection(%s)", dataType.toString()));
    }
}
