// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

/** The language to use for a Snowball token filter. */
public enum SnowballTokenFilterLanguage {
    /** Selects the Lucene Snowball stemming tokenizer for Armenian. */
    ARMENIAN("armenian"),

    /** Selects the Lucene Snowball stemming tokenizer for Basque. */
    BASQUE("basque"),

    /** Selects the Lucene Snowball stemming tokenizer for Catalan. */
    CATALAN("catalan"),

    /** Selects the Lucene Snowball stemming tokenizer for Danish. */
    DANISH("danish"),

    /** Selects the Lucene Snowball stemming tokenizer for Dutch. */
    DUTCH("dutch"),

    /** Selects the Lucene Snowball stemming tokenizer for English. */
    ENGLISH("english"),

    /** Selects the Lucene Snowball stemming tokenizer for Finnish. */
    FINNISH("finnish"),

    /** Selects the Lucene Snowball stemming tokenizer for French. */
    FRENCH("french"),

    /** Selects the Lucene Snowball stemming tokenizer for German. */
    GERMAN("german"),

    /** Selects the Lucene Snowball stemming tokenizer that uses the German variant algorithm. */
    GERMAN2("german2"),

    /** Selects the Lucene Snowball stemming tokenizer for Hungarian. */
    HUNGARIAN("hungarian"),

    /** Selects the Lucene Snowball stemming tokenizer for Italian. */
    ITALIAN("italian"),

    /** Selects the Lucene Snowball stemming tokenizer for Dutch that uses the Kraaij-Pohlmann stemming algorithm. */
    KP("kp"),

    /** Selects the Lucene Snowball stemming tokenizer for English that uses the Lovins stemming algorithm. */
    LOVINS("lovins"),

    /** Selects the Lucene Snowball stemming tokenizer for Norwegian. */
    NORWEGIAN("norwegian"),

    /** Selects the Lucene Snowball stemming tokenizer for English that uses the Porter stemming algorithm. */
    PORTER("porter"),

    /** Selects the Lucene Snowball stemming tokenizer for Portuguese. */
    PORTUGUESE("portuguese"),

    /** Selects the Lucene Snowball stemming tokenizer for Romanian. */
    ROMANIAN("romanian"),

    /** Selects the Lucene Snowball stemming tokenizer for Russian. */
    RUSSIAN("russian"),

    /** Selects the Lucene Snowball stemming tokenizer for Spanish. */
    SPANISH("spanish"),

    /** Selects the Lucene Snowball stemming tokenizer for Swedish. */
    SWEDISH("swedish"),

    /** Selects the Lucene Snowball stemming tokenizer for Turkish. */
    TURKISH("turkish");

    /** The actual serialized value for a SnowballTokenFilterLanguage instance. */
    private final String value;

    SnowballTokenFilterLanguage(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a SnowballTokenFilterLanguage instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed SnowballTokenFilterLanguage object, or null if unable to parse.
     */
    public static SnowballTokenFilterLanguage fromString(String value) {
        if (value == null) {
            return null;
        }
        SnowballTokenFilterLanguage[] items = SnowballTokenFilterLanguage.values();
        for (SnowballTokenFilterLanguage item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @Override
    public String toString() {
        return this.value;
    }
}
