// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

/** Identifies a predefined list of language-specific stopwords. */
public enum StopwordsList {
    /** Selects the stopword list for Arabic. */
    ARABIC("arabic"),

    /** Selects the stopword list for Armenian. */
    ARMENIAN("armenian"),

    /** Selects the stopword list for Basque. */
    BASQUE("basque"),

    /** Selects the stopword list for Portuguese (Brazil). */
    BRAZILIAN("brazilian"),

    /** Selects the stopword list for Bulgarian. */
    BULGARIAN("bulgarian"),

    /** Selects the stopword list for Catalan. */
    CATALAN("catalan"),

    /** Selects the stopword list for Czech. */
    CZECH("czech"),

    /** Selects the stopword list for Danish. */
    DANISH("danish"),

    /** Selects the stopword list for Dutch. */
    DUTCH("dutch"),

    /** Selects the stopword list for English. */
    ENGLISH("english"),

    /** Selects the stopword list for Finnish. */
    FINNISH("finnish"),

    /** Selects the stopword list for French. */
    FRENCH("french"),

    /** Selects the stopword list for Galician. */
    GALICIAN("galician"),

    /** Selects the stopword list for German. */
    GERMAN("german"),

    /** Selects the stopword list for Greek. */
    GREEK("greek"),

    /** Selects the stopword list for Hindi. */
    HINDI("hindi"),

    /** Selects the stopword list for Hungarian. */
    HUNGARIAN("hungarian"),

    /** Selects the stopword list for Indonesian. */
    INDONESIAN("indonesian"),

    /** Selects the stopword list for Irish. */
    IRISH("irish"),

    /** Selects the stopword list for Italian. */
    ITALIAN("italian"),

    /** Selects the stopword list for Latvian. */
    LATVIAN("latvian"),

    /** Selects the stopword list for Norwegian. */
    NORWEGIAN("norwegian"),

    /** Selects the stopword list for Persian. */
    PERSIAN("persian"),

    /** Selects the stopword list for Portuguese. */
    PORTUGUESE("portuguese"),

    /** Selects the stopword list for Romanian. */
    ROMANIAN("romanian"),

    /** Selects the stopword list for Russian. */
    RUSSIAN("russian"),

    /** Selects the stopword list for Sorani. */
    SORANI("sorani"),

    /** Selects the stopword list for Spanish. */
    SPANISH("spanish"),

    /** Selects the stopword list for Swedish. */
    SWEDISH("swedish"),

    /** Selects the stopword list for Thai. */
    THAI("thai"),

    /** Selects the stopword list for Turkish. */
    TURKISH("turkish");

    /** The actual serialized value for a StopwordsList instance. */
    private final String value;

    StopwordsList(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a StopwordsList instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed StopwordsList object, or null if unable to parse.
     */
    public static StopwordsList fromString(String value) {
        if (value == null) {
            return null;
        }
        StopwordsList[] items = StopwordsList.values();
        for (StopwordsList item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @Override
    public String toString() {
        return this.value;
    }
}
