// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

/** Represents classes of characters on which a token filter can operate. */
public enum TokenCharacterKind {
    /** Keeps letters in tokens. */
    LETTER("letter"),

    /** Keeps digits in tokens. */
    DIGIT("digit"),

    /** Keeps whitespace in tokens. */
    WHITESPACE("whitespace"),

    /** Keeps punctuation in tokens. */
    PUNCTUATION("punctuation"),

    /** Keeps symbols in tokens. */
    SYMBOL("symbol");

    /** The actual serialized value for a TokenCharacterKind instance. */
    private final String value;

    TokenCharacterKind(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a TokenCharacterKind instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed TokenCharacterKind object, or null if unable to parse.
     */
    public static TokenCharacterKind fromString(String value) {
        if (value == null) {
            return null;
        }
        TokenCharacterKind[] items = TokenCharacterKind.values();
        for (TokenCharacterKind item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @Override
    public String toString() {
        return this.value;
    }
}
