// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/** The similarity metric to use for vector comparisons. */
public final class VectorSearchAlgorithmMetric extends ExpandableStringEnum<VectorSearchAlgorithmMetric> {
    /** Static value cosine for VectorSearchAlgorithmMetric. */
    public static final VectorSearchAlgorithmMetric COSINE = fromString("cosine");

    /** Static value euclidean for VectorSearchAlgorithmMetric. */
    public static final VectorSearchAlgorithmMetric EUCLIDEAN = fromString("euclidean");

    /** Static value dotProduct for VectorSearchAlgorithmMetric. */
    public static final VectorSearchAlgorithmMetric DOT_PRODUCT = fromString("dotProduct");

    /**
     * Creates a new instance of VectorSearchAlgorithmMetric value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public VectorSearchAlgorithmMetric() {}

    /**
     * Creates or finds a VectorSearchAlgorithmMetric from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding VectorSearchAlgorithmMetric.
     */
    public static VectorSearchAlgorithmMetric fromString(String name) {
        return fromString(name, VectorSearchAlgorithmMetric.class);
    }

    /**
     * Gets known VectorSearchAlgorithmMetric values.
     *
     * @return known VectorSearchAlgorithmMetric values.
     */
    public static Collection<VectorSearchAlgorithmMetric> values() {
        return values(VectorSearchAlgorithmMetric.class);
    }
}
