// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/** The query parameters for vector and hybrid search queries. */
@Fluent
public class VectorQuery implements JsonSerializable<VectorQuery> {

    /*
     * Number of nearest neighbors to return as top hits.
     */
    private Integer kNearestNeighborsCount;

    /*
     * Vector Fields of type Collection(Edm.Single) to be included in the vector searched.
     */
    private String fields;

    /*
     * When true, triggers an exhaustive k-nearest neighbor search across all vectors within the vector index. Useful
     * for scenarios where exact matches are critical, such as determining ground truth values.
     */
    private Boolean exhaustive;

    /** Creates an instance of VectorQuery class. */
    public VectorQuery() {}

    /**
     * Get the kNearestNeighborsCount property: Number of nearest neighbors to return as top hits.
     *
     * @return the kNearestNeighborsCount value.
     */
    public Integer getKNearestNeighborsCount() {
        return this.kNearestNeighborsCount;
    }

    /**
     * Set the kNearestNeighborsCount property: Number of nearest neighbors to return as top hits.
     *
     * @param kNearestNeighborsCount the kNearestNeighborsCount value to set.
     * @return the VectorQuery object itself.
     */
    public VectorQuery setKNearestNeighborsCount(Integer kNearestNeighborsCount) {
        this.kNearestNeighborsCount = kNearestNeighborsCount;
        return this;
    }

    /**
     * Get the fields property: Vector Fields of type Collection(Edm.Single) to be included in the vector searched.
     *
     * @return the fields value.
     */
    public String getFields() {
        return this.fields;
    }

    /**
     * Set the fields property: Vector Fields of type Collection(Edm.Single) to be included in the vector searched.
     *
     * @param fields the fields value to set.
     * @return the VectorQuery object itself.
     */
    public VectorQuery setFields(String... fields) {
        this.fields = (fields == null) ? null : String.join(",", fields);
        return this;
    }

    /**
     * Get the exhaustive property: When true, triggers an exhaustive k-nearest neighbor search across all vectors
     * within the vector index. Useful for scenarios where exact matches are critical, such as determining ground truth
     * values.
     *
     * @return the exhaustive value.
     */
    public Boolean isExhaustive() {
        return this.exhaustive;
    }

    /**
     * Set the exhaustive property: When true, triggers an exhaustive k-nearest neighbor search across all vectors
     * within the vector index. Useful for scenarios where exact matches are critical, such as determining ground truth
     * values.
     *
     * @param exhaustive the exhaustive value to set.
     * @return the VectorQuery object itself.
     */
    public VectorQuery setExhaustive(Boolean exhaustive) {
        this.exhaustive = exhaustive;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("k", this.kNearestNeighborsCount);
        jsonWriter.writeStringField("fields", this.fields);
        jsonWriter.writeBooleanField("exhaustive", this.exhaustive);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorQuery from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorQuery if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing the polymorphic discriminator.
     * @throws IOException If an error occurs while reading the VectorQuery.
     */
    public static VectorQuery fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    String discriminatorValue = null;
                    JsonReader readerToUse = reader.bufferObject();
                    // Prepare for reading
                    readerToUse.nextToken();
                    while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = readerToUse.getFieldName();
                        readerToUse.nextToken();
                        if ("kind".equals(fieldName)) {
                            discriminatorValue = readerToUse.getString();
                            break;
                        } else {
                            readerToUse.skipChildren();
                        }
                    }
                    if (discriminatorValue != null) {
                        readerToUse = readerToUse.reset();
                    }
                    // Use the discriminator value to determine which subtype should be deserialized.
                    if ("vector".equals(discriminatorValue)) {
                        return VectorizedQuery.fromJson(readerToUse);
                    } else {
                        throw new IllegalStateException(
                                "Discriminator field 'kind' didn't match one of the expected values 'vector'");
                    }
                });
    }
}
