/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;

public final class UniqueTokenFilter
extends TokenFilter {
    private Boolean onlyOnSamePosition;

    public UniqueTokenFilter(String name) {
        super(name);
    }

    public Boolean isOnlyOnSamePosition() {
        return this.onlyOnSamePosition;
    }

    public UniqueTokenFilter setOnlyOnSamePosition(Boolean onlyOnSamePosition) {
        this.onlyOnSamePosition = onlyOnSamePosition;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.UniqueTokenFilter");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeBooleanField("onlyOnSamePosition", this.onlyOnSamePosition);
        return jsonWriter.writeEndObject();
    }

    public static UniqueTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (UniqueTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Boolean onlyOnSamePosition = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.UniqueTokenFilter".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.UniqueTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("onlyOnSamePosition".equals(fieldName)) {
                    onlyOnSamePosition = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                UniqueTokenFilter deserializedUniqueTokenFilter = new UniqueTokenFilter(name);
                deserializedUniqueTokenFilter.onlyOnSamePosition = onlyOnSamePosition;
                return deserializedUniqueTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

