/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.search.documents.SearchAsyncClient;
import com.azure.search.documents.SearchClientBuilder;
import com.azure.search.documents.SearchServiceVersion;
import com.azure.search.documents.implementation.converters.AnalyzeRequestConverter;
import com.azure.search.documents.implementation.util.FieldBuilder;
import com.azure.search.documents.implementation.util.MappingUtils;
import com.azure.search.documents.indexes.SearchIndexClientBuilder;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.ListSynonymMapsResult;
import com.azure.search.documents.indexes.models.AnalyzeTextOptions;
import com.azure.search.documents.indexes.models.AnalyzedTokenInfo;
import com.azure.search.documents.indexes.models.FieldBuilderOptions;
import com.azure.search.documents.indexes.models.SearchField;
import com.azure.search.documents.indexes.models.SearchIndex;
import com.azure.search.documents.indexes.models.SearchIndexStatistics;
import com.azure.search.documents.indexes.models.SearchServiceStatistics;
import com.azure.search.documents.indexes.models.SynonymMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SearchIndexClientBuilder.class, isAsync=true)
public final class SearchIndexAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(SearchIndexAsyncClient.class);
    private final SearchServiceVersion serviceVersion;
    private final String endpoint;
    private final SearchServiceClientImpl restClient;
    private final JsonSerializer serializer;
    private final HttpPipeline httpPipeline;

    SearchIndexAsyncClient(String endpoint, SearchServiceVersion serviceVersion, HttpPipeline httpPipeline, JsonSerializer serializer) {
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.httpPipeline = httpPipeline;
        this.serializer = serializer;
        this.restClient = new SearchServiceClientImpl(httpPipeline, endpoint, serviceVersion.getVersion());
    }

    HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public SearchAsyncClient getSearchAsyncClient(String indexName) {
        return SearchIndexAsyncClient.getSearchClientBuilder(indexName, this.endpoint, this.serviceVersion, this.httpPipeline, this.serializer).buildAsyncClient();
    }

    static SearchClientBuilder getSearchClientBuilder(String indexName, String endpoint, SearchServiceVersion serviceVersion, HttpPipeline httpPipeline, JsonSerializer serializer) {
        return new SearchClientBuilder().endpoint(endpoint).indexName(indexName).serviceVersion(serviceVersion).pipeline(httpPipeline).serializer(serializer);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndex> createIndex(SearchIndex index) {
        return this.createIndexWithResponse(index).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndex>> createIndexWithResponse(SearchIndex index) {
        return FluxUtil.withContext(context -> this.createIndexWithResponse(index, (Context)context));
    }

    Mono<Response<SearchIndex>> createIndexWithResponse(SearchIndex index, Context context) {
        try {
            Objects.requireNonNull(index, "'Index' cannot be null");
            return this.restClient.getIndexes().createWithResponseAsync(index, null, context).onErrorMap(MappingUtils::exceptionMapper);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndex> getIndex(String indexName) {
        return this.getIndexWithResponse(indexName).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndex>> getIndexWithResponse(String indexName) {
        return FluxUtil.withContext(context -> this.getIndexWithResponse(indexName, (Context)context));
    }

    Mono<Response<SearchIndex>> getIndexWithResponse(String indexName, Context context) {
        try {
            return this.restClient.getIndexes().getWithResponseAsync(indexName, null, context).onErrorMap(MappingUtils::exceptionMapper);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndexStatistics> getIndexStatistics(String indexName) {
        return this.getIndexStatisticsWithResponse(indexName).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndexStatistics>> getIndexStatisticsWithResponse(String indexName) {
        return FluxUtil.withContext(context -> this.getIndexStatisticsWithResponse(indexName, (Context)context));
    }

    Mono<Response<SearchIndexStatistics>> getIndexStatisticsWithResponse(String indexName, Context context) {
        try {
            return this.restClient.getIndexes().getStatisticsWithResponseAsync(indexName, null, context).onErrorMap(MappingUtils::exceptionMapper);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SearchIndex> listIndexes() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listIndexesWithResponse(null, (Context)context)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listIndexNames() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listIndexesWithResponse("name", (Context)context)).map(MappingUtils::mappingPagingSearchIndexNames));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<SearchIndex>> listIndexesWithResponse(String select, Context context) {
        return this.restClient.getIndexes().listSinglePageAsync(select, null, context).onErrorMap(MappingUtils::exceptionMapper);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchIndex> createOrUpdateIndex(SearchIndex index) {
        return this.createOrUpdateIndexWithResponse(index, false, false).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchIndex>> createOrUpdateIndexWithResponse(SearchIndex index, boolean allowIndexDowntime, boolean onlyIfUnchanged) {
        return FluxUtil.withContext(context -> this.createOrUpdateIndexWithResponse(index, allowIndexDowntime, onlyIfUnchanged, (Context)context));
    }

    Mono<Response<SearchIndex>> createOrUpdateIndexWithResponse(SearchIndex index, boolean allowIndexDowntime, boolean onlyIfUnchanged, Context context) {
        try {
            Objects.requireNonNull(index, "'Index' cannot null.");
            String ifMatch = onlyIfUnchanged ? index.getETag() : null;
            return this.restClient.getIndexes().createOrUpdateWithResponseAsync(index.getName(), index, allowIndexDowntime, ifMatch, null, null, context).onErrorMap(MappingUtils::exceptionMapper);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteIndex(String indexName) {
        return this.deleteIndexWithResponse(indexName, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteIndexWithResponse(SearchIndex index, boolean onlyIfUnchanged) {
        if (index == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'index' cannot be null."));
        }
        return FluxUtil.withContext(context -> this.deleteIndexWithResponse(index.getName(), onlyIfUnchanged ? index.getETag() : null, (Context)context));
    }

    Mono<Response<Void>> deleteIndexWithResponse(String indexName, String eTag, Context context) {
        try {
            return this.restClient.getIndexes().deleteWithResponseAsync(indexName, eTag, null, null, context).onErrorMap(MappingUtils::exceptionMapper).map(Function.identity());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnalyzedTokenInfo> analyzeText(String indexName, AnalyzeTextOptions analyzeTextOptions) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.analyzeTextWithResponse(indexName, analyzeTextOptions, (Context)context)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<AnalyzedTokenInfo>> analyzeTextWithResponse(String indexName, AnalyzeTextOptions analyzeTextOptions, Context context) {
        return this.restClient.getIndexes().analyzeWithResponseAsync(indexName, AnalyzeRequestConverter.map(analyzeTextOptions), null, context).onErrorMap(MappingUtils::exceptionMapper).map(MappingUtils::mappingTokenInfo);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SynonymMap> createSynonymMap(SynonymMap synonymMap) {
        return this.createSynonymMapWithResponse(synonymMap).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SynonymMap>> createSynonymMapWithResponse(SynonymMap synonymMap) {
        return FluxUtil.withContext(context -> this.createSynonymMapWithResponse(synonymMap, (Context)context));
    }

    Mono<Response<SynonymMap>> createSynonymMapWithResponse(SynonymMap synonymMap, Context context) {
        try {
            Objects.requireNonNull(synonymMap, "'synonymMap' cannot be null.");
            return this.restClient.getSynonymMaps().createWithResponseAsync(synonymMap, null, context).onErrorMap(MappingUtils::exceptionMapper);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SynonymMap> getSynonymMap(String synonymMapName) {
        return this.getSynonymMapWithResponse(synonymMapName).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SynonymMap>> getSynonymMapWithResponse(String synonymMapName) {
        return FluxUtil.withContext(context -> this.getSynonymMapWithResponse(synonymMapName, (Context)context));
    }

    Mono<Response<SynonymMap>> getSynonymMapWithResponse(String synonymMapName, Context context) {
        try {
            return this.restClient.getSynonymMaps().getWithResponseAsync(synonymMapName, null, context).onErrorMap(MappingUtils::exceptionMapper);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SynonymMap> listSynonymMaps() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listSynonymMapsWithResponse(null, (Context)context)).map(MappingUtils::mappingPagingSynonymMap));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listSynonymMapNames() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listSynonymMapsWithResponse("name", (Context)context)).map(MappingUtils::mappingPagingSynonymMapNames));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    private Mono<Response<ListSynonymMapsResult>> listSynonymMapsWithResponse(String select, Context context) {
        return this.restClient.getSynonymMaps().listWithResponseAsync(select, null, context).onErrorMap(MappingUtils::exceptionMapper);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SynonymMap> createOrUpdateSynonymMap(SynonymMap synonymMap) {
        return this.createOrUpdateSynonymMapWithResponse(synonymMap, false).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SynonymMap>> createOrUpdateSynonymMapWithResponse(SynonymMap synonymMap, boolean onlyIfUnchanged) {
        return FluxUtil.withContext(context -> this.createOrUpdateSynonymMapWithResponse(synonymMap, onlyIfUnchanged, (Context)context));
    }

    Mono<Response<SynonymMap>> createOrUpdateSynonymMapWithResponse(SynonymMap synonymMap, boolean onlyIfUnchanged, Context context) {
        try {
            Objects.requireNonNull(synonymMap, "'synonymMap' cannot be null.");
            String ifMatch = onlyIfUnchanged ? synonymMap.getETag() : null;
            return this.restClient.getSynonymMaps().createOrUpdateWithResponseAsync(synonymMap.getName(), synonymMap, ifMatch, null, null, context).onErrorMap(MappingUtils::exceptionMapper);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSynonymMap(String synonymMapName) {
        return FluxUtil.withContext(context -> this.deleteSynonymMapWithResponse(synonymMapName, null, (Context)context).flatMap(FluxUtil::toMono));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSynonymMapWithResponse(SynonymMap synonymMap, boolean onlyIfUnchanged) {
        if (synonymMap == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'synonymMap' cannot be null."));
        }
        return FluxUtil.withContext(context -> this.deleteSynonymMapWithResponse(synonymMap.getName(), onlyIfUnchanged ? synonymMap.getETag() : null, (Context)context));
    }

    public static List<SearchField> buildSearchFields(Class<?> model, FieldBuilderOptions options) {
        return FieldBuilder.build(model, options);
    }

    Mono<Response<Void>> deleteSynonymMapWithResponse(String synonymMapName, String etag, Context context) {
        try {
            return this.restClient.getSynonymMaps().deleteWithResponseAsync(synonymMapName, etag, null, null, context).onErrorMap(MappingUtils::exceptionMapper).map(Function.identity());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SearchServiceStatistics> getServiceStatistics() {
        return this.getServiceStatisticsWithResponse().map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SearchServiceStatistics>> getServiceStatisticsWithResponse() {
        return FluxUtil.withContext(this::getServiceStatisticsWithResponse);
    }

    Mono<Response<SearchServiceStatistics>> getServiceStatisticsWithResponse(Context context) {
        try {
            return this.restClient.getServiceStatisticsWithResponseAsync(null, context).onErrorMap(MappingUtils::exceptionMapper);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }
}

