/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;

public final class NGramTokenFilterV2
extends TokenFilter {
    private Integer minGram;
    private Integer maxGram;

    public NGramTokenFilterV2(String name) {
        super(name);
    }

    public Integer getMinGram() {
        return this.minGram;
    }

    public NGramTokenFilterV2 setMinGram(Integer minGram) {
        this.minGram = minGram;
        return this;
    }

    public Integer getMaxGram() {
        return this.maxGram;
    }

    public NGramTokenFilterV2 setMaxGram(Integer maxGram) {
        this.maxGram = maxGram;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.NGramTokenFilterV2");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeNumberField("minGram", (Number)this.minGram);
        jsonWriter.writeNumberField("maxGram", (Number)this.maxGram);
        return jsonWriter.writeEndObject();
    }

    public static NGramTokenFilterV2 fromJson(JsonReader jsonReader) throws IOException {
        return (NGramTokenFilterV2)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Integer minGram = null;
            Integer maxGram = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.NGramTokenFilterV2".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.NGramTokenFilterV2'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("minGram".equals(fieldName)) {
                    minGram = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxGram".equals(fieldName)) {
                    maxGram = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                NGramTokenFilterV2 deserializedNGramTokenFilterV2 = new NGramTokenFilterV2(name);
                deserializedNGramTokenFilterV2.minGram = minGram;
                deserializedNGramTokenFilterV2.maxGram = maxGram;
                return deserializedNGramTokenFilterV2;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

