/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SimilarityAlgorithm;
import java.io.IOException;

public final class BM25SimilarityAlgorithm
extends SimilarityAlgorithm {
    private Double k1;
    private Double b;

    public Double getK1() {
        return this.k1;
    }

    public BM25SimilarityAlgorithm setK1(Double k1) {
        this.k1 = k1;
        return this;
    }

    public Double getB() {
        return this.b;
    }

    public BM25SimilarityAlgorithm setB(Double b) {
        this.b = b;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.BM25Similarity");
        jsonWriter.writeNumberField("k1", (Number)this.k1);
        jsonWriter.writeNumberField("b", (Number)this.b);
        return jsonWriter.writeEndObject();
    }

    public static BM25SimilarityAlgorithm fromJson(JsonReader jsonReader) throws IOException {
        return (BM25SimilarityAlgorithm)jsonReader.readObject(reader -> {
            BM25SimilarityAlgorithm deserializedBM25SimilarityAlgorithm = new BM25SimilarityAlgorithm();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.BM25Similarity".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.BM25Similarity'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("k1".equals(fieldName)) {
                    deserializedBM25SimilarityAlgorithm.k1 = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("b".equals(fieldName)) {
                    deserializedBM25SimilarityAlgorithm.b = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBM25SimilarityAlgorithm;
        });
    }
}

