/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class ResourceCounter
implements JsonSerializable<ResourceCounter> {
    private final long usage;
    private Long quota;

    public ResourceCounter(long usage) {
        this.usage = usage;
    }

    public long getUsage() {
        return this.usage;
    }

    public Long getQuota() {
        return this.quota;
    }

    public ResourceCounter setQuota(Long quota) {
        this.quota = quota;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("usage", this.usage);
        jsonWriter.writeNumberField("quota", (Number)this.quota);
        return jsonWriter.writeEndObject();
    }

    public static ResourceCounter fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceCounter)jsonReader.readObject(reader -> {
            boolean usageFound = false;
            long usage = 0L;
            Long quota = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("usage".equals(fieldName)) {
                    usage = reader.getLong();
                    usageFound = true;
                    continue;
                }
                if ("quota".equals(fieldName)) {
                    quota = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            if (usageFound) {
                ResourceCounter deserializedResourceCounter = new ResourceCounter(usage);
                deserializedResourceCounter.quota = quota;
                return deserializedResourceCounter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!usageFound) {
                missingProperties.add("usage");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

