/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreBlobProjectionSelector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SearchIndexerKnowledgeStoreObjectProjectionSelector
extends SearchIndexerKnowledgeStoreBlobProjectionSelector {
    public SearchIndexerKnowledgeStoreObjectProjectionSelector(String storageContainer) {
        super(storageContainer);
    }

    @Override
    public SearchIndexerKnowledgeStoreObjectProjectionSelector setReferenceKeyName(String referenceKeyName) {
        super.setReferenceKeyName(referenceKeyName);
        return this;
    }

    @Override
    public SearchIndexerKnowledgeStoreObjectProjectionSelector setGeneratedKeyName(String generatedKeyName) {
        super.setGeneratedKeyName(generatedKeyName);
        return this;
    }

    @Override
    public SearchIndexerKnowledgeStoreObjectProjectionSelector setSource(String source) {
        super.setSource(source);
        return this;
    }

    @Override
    public SearchIndexerKnowledgeStoreObjectProjectionSelector setSourceContext(String sourceContext) {
        super.setSourceContext(sourceContext);
        return this;
    }

    @Override
    public SearchIndexerKnowledgeStoreObjectProjectionSelector setInputs(List<InputFieldMappingEntry> inputs) {
        super.setInputs((List)inputs);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageContainer", this.getStorageContainer());
        jsonWriter.writeStringField("referenceKeyName", this.getReferenceKeyName());
        jsonWriter.writeStringField("generatedKeyName", this.getGeneratedKeyName());
        jsonWriter.writeStringField("source", this.getSource());
        jsonWriter.writeStringField("sourceContext", this.getSourceContext());
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerKnowledgeStoreObjectProjectionSelector fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerKnowledgeStoreObjectProjectionSelector)jsonReader.readObject(reader -> {
            boolean storageContainerFound = false;
            String storageContainer = null;
            String referenceKeyName = null;
            String generatedKeyName = null;
            String source = null;
            String sourceContext = null;
            List inputs = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageContainer".equals(fieldName)) {
                    storageContainer = reader.getString();
                    storageContainerFound = true;
                    continue;
                }
                if ("referenceKeyName".equals(fieldName)) {
                    referenceKeyName = reader.getString();
                    continue;
                }
                if ("generatedKeyName".equals(fieldName)) {
                    generatedKeyName = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    source = reader.getString();
                    continue;
                }
                if ("sourceContext".equals(fieldName)) {
                    sourceContext = reader.getString();
                    continue;
                }
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (storageContainerFound) {
                SearchIndexerKnowledgeStoreObjectProjectionSelector deserializedSearchIndexerKnowledgeStoreObjectProjectionSelector = new SearchIndexerKnowledgeStoreObjectProjectionSelector(storageContainer);
                deserializedSearchIndexerKnowledgeStoreObjectProjectionSelector.setReferenceKeyName(referenceKeyName);
                deserializedSearchIndexerKnowledgeStoreObjectProjectionSelector.setGeneratedKeyName(generatedKeyName);
                deserializedSearchIndexerKnowledgeStoreObjectProjectionSelector.setSource(source);
                deserializedSearchIndexerKnowledgeStoreObjectProjectionSelector.setSourceContext(sourceContext);
                deserializedSearchIndexerKnowledgeStoreObjectProjectionSelector.setInputs(inputs);
                return deserializedSearchIndexerKnowledgeStoreObjectProjectionSelector;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!storageContainerFound) {
                missingProperties.add("storageContainer");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

