/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.IndexingResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class IndexDocumentsResult
implements JsonSerializable<IndexDocumentsResult> {
    private final List<IndexingResult> results;

    public IndexDocumentsResult(List<IndexingResult> results) {
        this.results = results;
    }

    public List<IndexingResult> getResults() {
        return this.results;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static IndexDocumentsResult fromJson(JsonReader jsonReader) throws IOException {
        return (IndexDocumentsResult)jsonReader.readObject(reader -> {
            boolean resultsFound = false;
            List results = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    results = reader.readArray(reader1 -> IndexingResult.fromJson(reader1));
                    resultsFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (resultsFound) {
                IndexDocumentsResult deserializedIndexDocumentsResult = new IndexDocumentsResult(results);
                return deserializedIndexDocumentsResult;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!resultsFound) {
                missingProperties.add("value");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

