/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class CorsOptions
implements JsonSerializable<CorsOptions> {
    private final List<String> allowedOrigins;
    private Long maxAgeInSeconds;

    public CorsOptions(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public Long getMaxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    public CorsOptions setMaxAgeInSeconds(Long maxAgeInSeconds) {
        this.maxAgeInSeconds = maxAgeInSeconds;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedOrigins", this.allowedOrigins, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("maxAgeInSeconds", (Number)this.maxAgeInSeconds);
        return jsonWriter.writeEndObject();
    }

    public static CorsOptions fromJson(JsonReader jsonReader) throws IOException {
        return (CorsOptions)jsonReader.readObject(reader -> {
            boolean allowedOriginsFound = false;
            List allowedOrigins = null;
            Long maxAgeInSeconds = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowedOrigins".equals(fieldName)) {
                    allowedOrigins = reader.readArray(reader1 -> reader1.getString());
                    allowedOriginsFound = true;
                    continue;
                }
                if ("maxAgeInSeconds".equals(fieldName)) {
                    maxAgeInSeconds = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            if (allowedOriginsFound) {
                CorsOptions deserializedCorsOptions = new CorsOptions(allowedOrigins);
                deserializedCorsOptions.maxAgeInSeconds = maxAgeInSeconds;
                return deserializedCorsOptions;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!allowedOriginsFound) {
                missingProperties.add("allowedOrigins");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

