/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CustomEntity;
import com.azure.search.documents.indexes.models.CustomEntityLookupSkillLanguage;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class CustomEntityLookupSkill
extends SearchIndexerSkill {
    private CustomEntityLookupSkillLanguage defaultLanguageCode;
    private String entitiesDefinitionUri;
    private List<CustomEntity> inlineEntitiesDefinition;
    private Boolean globalDefaultCaseSensitive;
    private Boolean globalDefaultAccentSensitive;
    private Integer globalDefaultFuzzyEditDistance;

    public CustomEntityLookupSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    public CustomEntityLookupSkillLanguage getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    public CustomEntityLookupSkill setDefaultLanguageCode(CustomEntityLookupSkillLanguage defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
        return this;
    }

    public String getEntitiesDefinitionUri() {
        return this.entitiesDefinitionUri;
    }

    public CustomEntityLookupSkill setEntitiesDefinitionUri(String entitiesDefinitionUri) {
        this.entitiesDefinitionUri = entitiesDefinitionUri;
        return this;
    }

    public List<CustomEntity> getInlineEntitiesDefinition() {
        return this.inlineEntitiesDefinition;
    }

    public CustomEntityLookupSkill setInlineEntitiesDefinition(List<CustomEntity> inlineEntitiesDefinition) {
        this.inlineEntitiesDefinition = inlineEntitiesDefinition;
        return this;
    }

    public Boolean isGlobalDefaultCaseSensitive() {
        return this.globalDefaultCaseSensitive;
    }

    public CustomEntityLookupSkill setGlobalDefaultCaseSensitive(Boolean globalDefaultCaseSensitive) {
        this.globalDefaultCaseSensitive = globalDefaultCaseSensitive;
        return this;
    }

    public Boolean isGlobalDefaultAccentSensitive() {
        return this.globalDefaultAccentSensitive;
    }

    public CustomEntityLookupSkill setGlobalDefaultAccentSensitive(Boolean globalDefaultAccentSensitive) {
        this.globalDefaultAccentSensitive = globalDefaultAccentSensitive;
        return this;
    }

    public Integer getGlobalDefaultFuzzyEditDistance() {
        return this.globalDefaultFuzzyEditDistance;
    }

    public CustomEntityLookupSkill setGlobalDefaultFuzzyEditDistance(Integer globalDefaultFuzzyEditDistance) {
        this.globalDefaultFuzzyEditDistance = globalDefaultFuzzyEditDistance;
        return this;
    }

    @Override
    public CustomEntityLookupSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public CustomEntityLookupSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public CustomEntityLookupSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Skills.Text.CustomEntityLookupSkill");
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("defaultLanguageCode", Objects.toString((Object)this.defaultLanguageCode, null));
        jsonWriter.writeStringField("entitiesDefinitionUri", this.entitiesDefinitionUri);
        jsonWriter.writeArrayField("inlineEntitiesDefinition", this.inlineEntitiesDefinition, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("globalDefaultCaseSensitive", this.globalDefaultCaseSensitive);
        jsonWriter.writeBooleanField("globalDefaultAccentSensitive", this.globalDefaultAccentSensitive);
        jsonWriter.writeNumberField("globalDefaultFuzzyEditDistance", (Number)this.globalDefaultFuzzyEditDistance);
        return jsonWriter.writeEndObject();
    }

    public static CustomEntityLookupSkill fromJson(JsonReader jsonReader) throws IOException {
        return (CustomEntityLookupSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            CustomEntityLookupSkillLanguage defaultLanguageCode = null;
            String entitiesDefinitionUri = null;
            List inlineEntitiesDefinition = null;
            Boolean globalDefaultCaseSensitive = null;
            Boolean globalDefaultAccentSensitive = null;
            Integer globalDefaultFuzzyEditDistance = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Skills.Text.CustomEntityLookupSkill".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Skills.Text.CustomEntityLookupSkill'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("defaultLanguageCode".equals(fieldName)) {
                    defaultLanguageCode = CustomEntityLookupSkillLanguage.fromString(reader.getString());
                    continue;
                }
                if ("entitiesDefinitionUri".equals(fieldName)) {
                    entitiesDefinitionUri = reader.getString();
                    continue;
                }
                if ("inlineEntitiesDefinition".equals(fieldName)) {
                    inlineEntitiesDefinition = reader.readArray(reader1 -> CustomEntity.fromJson(reader1));
                    continue;
                }
                if ("globalDefaultCaseSensitive".equals(fieldName)) {
                    globalDefaultCaseSensitive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("globalDefaultAccentSensitive".equals(fieldName)) {
                    globalDefaultAccentSensitive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("globalDefaultFuzzyEditDistance".equals(fieldName)) {
                    globalDefaultFuzzyEditDistance = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                CustomEntityLookupSkill deserializedCustomEntityLookupSkill = new CustomEntityLookupSkill(inputs, outputs);
                deserializedCustomEntityLookupSkill.setName(name);
                deserializedCustomEntityLookupSkill.setDescription(description);
                deserializedCustomEntityLookupSkill.setContext(context);
                deserializedCustomEntityLookupSkill.defaultLanguageCode = defaultLanguageCode;
                deserializedCustomEntityLookupSkill.entitiesDefinitionUri = entitiesDefinitionUri;
                deserializedCustomEntityLookupSkill.inlineEntitiesDefinition = inlineEntitiesDefinition;
                deserializedCustomEntityLookupSkill.globalDefaultCaseSensitive = globalDefaultCaseSensitive;
                deserializedCustomEntityLookupSkill.globalDefaultAccentSensitive = globalDefaultAccentSensitive;
                deserializedCustomEntityLookupSkill.globalDefaultFuzzyEditDistance = globalDefaultFuzzyEditDistance;
                return deserializedCustomEntityLookupSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public CustomEntityLookupSkill setInlineEntitiesDefinition(CustomEntity ... inlineEntitiesDefinition) {
        this.inlineEntitiesDefinition = inlineEntitiesDefinition == null ? null : Arrays.asList(inlineEntitiesDefinition);
        return this;
    }
}

