/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.VectorSearchAlgorithmKind;
import com.azure.search.documents.indexes.models.ExhaustiveKnnParameters;
import com.azure.search.documents.indexes.models.VectorSearchAlgorithmConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public final class ExhaustiveKnnAlgorithmConfiguration
extends VectorSearchAlgorithmConfiguration {
    private ExhaustiveKnnParameters parameters;

    public ExhaustiveKnnAlgorithmConfiguration(String name) {
        super(name);
    }

    public ExhaustiveKnnParameters getParameters() {
        return this.parameters;
    }

    public ExhaustiveKnnAlgorithmConfiguration setParameters(ExhaustiveKnnParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)VectorSearchAlgorithmKind.EXHAUSTIVE_KNN, null));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeJsonField("exhaustiveKnnParameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static ExhaustiveKnnAlgorithmConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ExhaustiveKnnAlgorithmConfiguration)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            ExhaustiveKnnParameters parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("exhaustiveKnn".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'exhaustiveKnn'. The found 'kind' was '" + kind + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("exhaustiveKnnParameters".equals(fieldName)) {
                    parameters = ExhaustiveKnnParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                ExhaustiveKnnAlgorithmConfiguration deserializedExhaustiveKnnAlgorithmConfiguration = new ExhaustiveKnnAlgorithmConfiguration(name);
                deserializedExhaustiveKnnAlgorithmConfiguration.parameters = parameters;
                return deserializedExhaustiveKnnAlgorithmConfiguration;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

