/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.util.Context;
import com.azure.search.documents.SearchClientBuilder;
import com.azure.search.documents.SearchIndexingBufferedAsyncSender;
import com.azure.search.documents.models.IndexAction;
import com.azure.search.documents.models.IndexActionType;
import java.time.Duration;
import java.util.Collection;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SearchClientBuilder.class)
public final class SearchIndexingBufferedSender<T> {
    final SearchIndexingBufferedAsyncSender<T> client;

    SearchIndexingBufferedSender(SearchIndexingBufferedAsyncSender<T> client) {
        this.client = client;
    }

    public Collection<IndexAction<T>> getActions() {
        return this.client.getActions();
    }

    int getBatchActionCount() {
        return this.client.getBatchActionCount();
    }

    public void addUploadActions(Collection<T> documents) {
        this.addUploadActions(documents, null, Context.NONE);
    }

    public void addUploadActions(Collection<T> documents, Duration timeout, Context context) {
        SearchIndexingBufferedSender.blockWithOptionalTimeout(this.client.createAndAddActions(documents, IndexActionType.UPLOAD, context), timeout);
    }

    public void addDeleteActions(Collection<T> documents) {
        this.addDeleteActions(documents, null, Context.NONE);
    }

    public void addDeleteActions(Collection<T> documents, Duration timeout, Context context) {
        SearchIndexingBufferedSender.blockWithOptionalTimeout(this.client.createAndAddActions(documents, IndexActionType.DELETE, context), timeout);
    }

    public void addMergeActions(Collection<T> documents) {
        this.addMergeActions(documents, null, Context.NONE);
    }

    public void addMergeActions(Collection<T> documents, Duration timeout, Context context) {
        SearchIndexingBufferedSender.blockWithOptionalTimeout(this.client.createAndAddActions(documents, IndexActionType.MERGE, context), timeout);
    }

    public void addMergeOrUploadActions(Collection<T> documents) {
        this.addMergeOrUploadActions(documents, null, Context.NONE);
    }

    public void addMergeOrUploadActions(Collection<T> documents, Duration timeout, Context context) {
        SearchIndexingBufferedSender.blockWithOptionalTimeout(this.client.createAndAddActions(documents, IndexActionType.MERGE_OR_UPLOAD, context), timeout);
    }

    public void addActions(Collection<IndexAction<T>> actions) {
        this.addActions(actions, null, Context.NONE);
    }

    public void addActions(Collection<IndexAction<T>> actions, Duration timeout, Context context) {
        SearchIndexingBufferedSender.blockWithOptionalTimeout(this.client.addActions(actions, context), timeout);
    }

    public void flush() {
        this.flush(null, Context.NONE);
    }

    public void flush(Duration timeout, Context context) {
        SearchIndexingBufferedSender.blockWithOptionalTimeout(this.client.flush(context), timeout);
    }

    public void close() {
        this.close(null, Context.NONE);
    }

    public void close(Duration timeout, Context context) {
        SearchIndexingBufferedSender.blockWithOptionalTimeout(this.client.close(context), timeout);
    }

    private static void blockWithOptionalTimeout(Mono<?> operation, Duration timeout) {
        if (timeout == null) {
            operation.block();
        } else {
            operation.block(timeout);
        }
    }
}

