/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.IndexActionType;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class IndexAction
implements JsonSerializable<IndexAction> {
    private IndexActionType actionType;
    private Map<String, Object> additionalProperties;
    private String rawDocument;

    public IndexActionType getActionType() {
        return this.actionType;
    }

    public IndexAction setActionType(IndexActionType actionType) {
        this.actionType = actionType;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public IndexAction setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@search.action", Objects.toString((Object)this.actionType, null));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static IndexAction fromJson(JsonReader jsonReader) throws IOException {
        return (IndexAction)jsonReader.readObject(reader -> {
            IndexAction deserializedIndexAction = new IndexAction();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@search.action".equals(fieldName)) {
                    deserializedIndexAction.actionType = IndexActionType.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedIndexAction.additionalProperties = additionalProperties;
            return deserializedIndexAction;
        });
    }

    public String getRawDocument() {
        return this.rawDocument;
    }

    public IndexAction setRawDocument(String rawDocument) {
        this.rawDocument = rawDocument;
        return this;
    }
}

