/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.QueryCaptionResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SearchResult
implements JsonSerializable<SearchResult> {
    private final double score;
    private Double rerankerScore;
    private Map<String, List<String>> highlights;
    private List<QueryCaptionResult> captions;
    private Map<String, Object> additionalProperties;

    public SearchResult(double score) {
        this.score = score;
    }

    public double getScore() {
        return this.score;
    }

    public Double getRerankerScore() {
        return this.rerankerScore;
    }

    public Map<String, List<String>> getHighlights() {
        return this.highlights;
    }

    public List<QueryCaptionResult> getCaptions() {
        return this.captions;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public SearchResult setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SearchResult fromJson(JsonReader jsonReader) throws IOException {
        return (SearchResult)jsonReader.readObject(reader -> {
            boolean scoreFound = false;
            double score = 0.0;
            Double rerankerScore = null;
            Map highlights = null;
            List captions = null;
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@search.score".equals(fieldName)) {
                    score = reader.getDouble();
                    scoreFound = true;
                    continue;
                }
                if ("@search.rerankerScore".equals(fieldName)) {
                    rerankerScore = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("@search.highlights".equals(fieldName)) {
                    highlights = reader.readMap(reader1 -> reader1.readArray(reader2 -> reader2.getString()));
                    continue;
                }
                if ("@search.captions".equals(fieldName)) {
                    captions = reader.readArray(reader1 -> QueryCaptionResult.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            if (scoreFound) {
                SearchResult deserializedSearchResult = new SearchResult(score);
                deserializedSearchResult.rerankerScore = rerankerScore;
                deserializedSearchResult.highlights = highlights;
                deserializedSearchResult.captions = captions;
                deserializedSearchResult.additionalProperties = additionalProperties;
                return deserializedSearchResult;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!scoreFound) {
                missingProperties.add("@search.score");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

