/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.implementation.util.Utility;
import com.azure.search.documents.indexes.models.SearchResourceEncryptionKey;
import java.io.IOException;
import java.nio.file.Path;

public final class SynonymMap
implements JsonSerializable<SynonymMap> {
    private String name;
    private String format = "solr";
    private String synonyms;
    private SearchResourceEncryptionKey encryptionKey;
    private String eTag;

    public SynonymMap() {
    }

    public String getName() {
        return this.name;
    }

    public String getSynonyms() {
        return this.synonyms;
    }

    public SynonymMap setSynonyms(String synonyms) {
        this.synonyms = synonyms;
        return this;
    }

    public SearchResourceEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public SynonymMap setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SynonymMap setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("format", this.format);
        jsonWriter.writeStringField("synonyms", this.synonyms);
        jsonWriter.writeJsonField("encryptionKey", (JsonSerializable)this.encryptionKey);
        jsonWriter.writeStringField("@odata.etag", this.eTag);
        return jsonWriter.writeEndObject();
    }

    public static SynonymMap fromJson(JsonReader jsonReader) throws IOException {
        return (SynonymMap)jsonReader.readObject(reader -> {
            SynonymMap deserializedSynonymMap = new SynonymMap();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSynonymMap.name = reader.getString();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedSynonymMap.format = reader.getString();
                    continue;
                }
                if ("synonyms".equals(fieldName)) {
                    deserializedSynonymMap.synonyms = reader.getString();
                    continue;
                }
                if ("encryptionKey".equals(fieldName)) {
                    deserializedSynonymMap.encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                    continue;
                }
                if ("@odata.etag".equals(fieldName)) {
                    deserializedSynonymMap.eTag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSynonymMap;
        });
    }

    public SynonymMap(String name) {
        this(name, null);
    }

    public SynonymMap(String name, String synonyms) {
        this.name = name;
        this.synonyms = synonyms;
    }

    public static SynonymMap createFromFile(String name, Path filePath) {
        String synonyms = Utility.readSynonymsFromFile(filePath);
        return new SynonymMap(name, synonyms);
    }
}

