/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.implementation.models.VectorQueryKind;
import com.azure.search.documents.models.VectorQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class VectorizedQuery
extends VectorQuery {
    private final List<Float> vector;

    public VectorizedQuery(List<Float> vector) {
        this.vector = vector;
    }

    public List<Float> getVector() {
        return this.vector;
    }

    @Override
    public VectorizedQuery setKNearestNeighborsCount(Integer kNearestNeighborsCount) {
        super.setKNearestNeighborsCount(kNearestNeighborsCount);
        return this;
    }

    @Override
    public VectorizedQuery setFields(String ... fields) {
        super.setFields(fields);
        return this;
    }

    @Override
    public VectorizedQuery setExhaustive(Boolean exhaustive) {
        super.setExhaustive(exhaustive);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)VectorQueryKind.VECTOR, null));
        jsonWriter.writeNumberField("k", (Number)this.getKNearestNeighborsCount());
        jsonWriter.writeStringField("fields", this.getFields());
        jsonWriter.writeBooleanField("exhaustive", this.isExhaustive());
        jsonWriter.writeArrayField("vector", this.vector, (writer, element) -> writer.writeFloat(element.floatValue()));
        return jsonWriter.writeEndObject();
    }

    public static VectorizedQuery fromJson(JsonReader jsonReader) throws IOException {
        return (VectorizedQuery)jsonReader.readObject(reader -> {
            Integer kNearestNeighborsCount = null;
            String fields = null;
            Boolean exhaustive = null;
            boolean vectorFound = false;
            List vector = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("vector".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'vector'. The found 'kind' was '" + kind + "'.");
                }
                if ("k".equals(fieldName)) {
                    kNearestNeighborsCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    fields = reader.getString();
                    continue;
                }
                if ("exhaustive".equals(fieldName)) {
                    exhaustive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("vector".equals(fieldName)) {
                    vector = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    vectorFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (vectorFound) {
                VectorizedQuery deserializedVectorizedQuery = new VectorizedQuery(vector);
                deserializedVectorizedQuery.setKNearestNeighborsCount(kNearestNeighborsCount);
                deserializedVectorizedQuery.setFields(fields);
                deserializedVectorizedQuery.setExhaustive(exhaustive);
                return deserializedVectorizedQuery;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!vectorFound) {
                missingProperties.add("vector");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

