/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.AzureOpenAIVectorizerParameters;
import com.azure.search.documents.indexes.models.VectorSearchVectorizer;
import com.azure.search.documents.indexes.models.VectorSearchVectorizerKind;
import java.io.IOException;

public final class AzureOpenAIVectorizer
extends VectorSearchVectorizer {
    private VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.AZURE_OPEN_AI;
    private AzureOpenAIVectorizerParameters parameters;

    public AzureOpenAIVectorizer(String vectorizerName) {
        super(vectorizerName);
    }

    @Override
    public VectorSearchVectorizerKind getKind() {
        return this.kind;
    }

    public AzureOpenAIVectorizerParameters getParameters() {
        return this.parameters;
    }

    public AzureOpenAIVectorizer setParameters(AzureOpenAIVectorizerParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getVectorizerName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("azureOpenAIParameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static AzureOpenAIVectorizer fromJson(JsonReader jsonReader) throws IOException {
        return (AzureOpenAIVectorizer)jsonReader.readObject(reader -> {
            boolean vectorizerNameFound = false;
            String vectorizerName = null;
            VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.AZURE_OPEN_AI;
            AzureOpenAIVectorizerParameters parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    vectorizerName = reader.getString();
                    vectorizerNameFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorSearchVectorizerKind.fromString(reader.getString());
                    continue;
                }
                if ("azureOpenAIParameters".equals(fieldName)) {
                    parameters = AzureOpenAIVectorizerParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (vectorizerNameFound) {
                AzureOpenAIVectorizer deserializedAzureOpenAIVectorizer = new AzureOpenAIVectorizer(vectorizerName);
                deserializedAzureOpenAIVectorizer.kind = kind;
                deserializedAzureOpenAIVectorizer.parameters = parameters;
                return deserializedAzureOpenAIVectorizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

