/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.implementation.models.IndexAction;
import java.io.IOException;
import java.util.List;

public final class IndexBatch
implements JsonSerializable<IndexBatch> {
    private final List<IndexAction> actions;

    public IndexBatch(List<IndexAction> actions) {
        this.actions = actions;
    }

    public List<IndexAction> getActions() {
        return this.actions;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.actions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static IndexBatch fromJson(JsonReader jsonReader) throws IOException {
        return (IndexBatch)jsonReader.readObject(reader -> {
            boolean actionsFound = false;
            List actions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    actions = reader.readArray(reader1 -> IndexAction.fromJson(reader1));
                    actionsFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (actionsFound) {
                return new IndexBatch(actions);
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}

