/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.CustomEntityAlias;
import java.io.IOException;
import java.util.List;

public final class CustomEntity
implements JsonSerializable<CustomEntity> {
    private final String name;
    private String description;
    private String type;
    private String subtype;
    private String id;
    private Boolean caseSensitive;
    private Boolean accentSensitive;
    private Integer fuzzyEditDistance;
    private Boolean defaultCaseSensitive;
    private Boolean defaultAccentSensitive;
    private Integer defaultFuzzyEditDistance;
    private List<CustomEntityAlias> aliases;

    public CustomEntity(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public CustomEntity setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public CustomEntity setType(String type) {
        this.type = type;
        return this;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public CustomEntity setSubtype(String subtype) {
        this.subtype = subtype;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public CustomEntity setId(String id) {
        this.id = id;
        return this;
    }

    public Boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public CustomEntity setCaseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public Boolean isAccentSensitive() {
        return this.accentSensitive;
    }

    public CustomEntity setAccentSensitive(Boolean accentSensitive) {
        this.accentSensitive = accentSensitive;
        return this;
    }

    public Integer getFuzzyEditDistance() {
        return this.fuzzyEditDistance;
    }

    public CustomEntity setFuzzyEditDistance(Integer fuzzyEditDistance) {
        this.fuzzyEditDistance = fuzzyEditDistance;
        return this;
    }

    public Boolean isDefaultCaseSensitive() {
        return this.defaultCaseSensitive;
    }

    public CustomEntity setDefaultCaseSensitive(Boolean defaultCaseSensitive) {
        this.defaultCaseSensitive = defaultCaseSensitive;
        return this;
    }

    public Boolean isDefaultAccentSensitive() {
        return this.defaultAccentSensitive;
    }

    public CustomEntity setDefaultAccentSensitive(Boolean defaultAccentSensitive) {
        this.defaultAccentSensitive = defaultAccentSensitive;
        return this;
    }

    public Integer getDefaultFuzzyEditDistance() {
        return this.defaultFuzzyEditDistance;
    }

    public CustomEntity setDefaultFuzzyEditDistance(Integer defaultFuzzyEditDistance) {
        this.defaultFuzzyEditDistance = defaultFuzzyEditDistance;
        return this;
    }

    public List<CustomEntityAlias> getAliases() {
        return this.aliases;
    }

    public CustomEntity setAliases(List<CustomEntityAlias> aliases) {
        this.aliases = aliases;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("subtype", this.subtype);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeBooleanField("caseSensitive", this.caseSensitive);
        jsonWriter.writeBooleanField("accentSensitive", this.accentSensitive);
        jsonWriter.writeNumberField("fuzzyEditDistance", (Number)this.fuzzyEditDistance);
        jsonWriter.writeBooleanField("defaultCaseSensitive", this.defaultCaseSensitive);
        jsonWriter.writeBooleanField("defaultAccentSensitive", this.defaultAccentSensitive);
        jsonWriter.writeNumberField("defaultFuzzyEditDistance", (Number)this.defaultFuzzyEditDistance);
        jsonWriter.writeArrayField("aliases", this.aliases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CustomEntity fromJson(JsonReader jsonReader) throws IOException {
        return (CustomEntity)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String description = null;
            String type = null;
            String subtype = null;
            String id = null;
            Boolean caseSensitive = null;
            Boolean accentSensitive = null;
            Integer fuzzyEditDistance = null;
            Boolean defaultCaseSensitive = null;
            Boolean defaultAccentSensitive = null;
            Integer defaultFuzzyEditDistance = null;
            List aliases = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("subtype".equals(fieldName)) {
                    subtype = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("caseSensitive".equals(fieldName)) {
                    caseSensitive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("accentSensitive".equals(fieldName)) {
                    accentSensitive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("fuzzyEditDistance".equals(fieldName)) {
                    fuzzyEditDistance = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("defaultCaseSensitive".equals(fieldName)) {
                    defaultCaseSensitive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultAccentSensitive".equals(fieldName)) {
                    defaultAccentSensitive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultFuzzyEditDistance".equals(fieldName)) {
                    defaultFuzzyEditDistance = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("aliases".equals(fieldName)) {
                    aliases = reader.readArray(reader1 -> CustomEntityAlias.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                CustomEntity deserializedCustomEntity = new CustomEntity(name);
                deserializedCustomEntity.description = description;
                deserializedCustomEntity.type = type;
                deserializedCustomEntity.subtype = subtype;
                deserializedCustomEntity.id = id;
                deserializedCustomEntity.caseSensitive = caseSensitive;
                deserializedCustomEntity.accentSensitive = accentSensitive;
                deserializedCustomEntity.fuzzyEditDistance = fuzzyEditDistance;
                deserializedCustomEntity.defaultCaseSensitive = defaultCaseSensitive;
                deserializedCustomEntity.defaultAccentSensitive = defaultAccentSensitive;
                deserializedCustomEntity.defaultFuzzyEditDistance = defaultFuzzyEditDistance;
                deserializedCustomEntity.aliases = aliases;
                return deserializedCustomEntity;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

