/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class KeywordMarkerTokenFilter
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.KeywordMarkerTokenFilter";
    private final List<String> keywords;
    private Boolean caseIgnored;

    public KeywordMarkerTokenFilter(String name, List<String> keywords) {
        super(name);
        this.keywords = keywords;
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public Boolean isCaseIgnored() {
        return this.caseIgnored;
    }

    public KeywordMarkerTokenFilter setCaseIgnored(Boolean caseIgnored) {
        this.caseIgnored = caseIgnored;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeArrayField("keywords", this.keywords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeBooleanField("ignoreCase", this.caseIgnored);
        return jsonWriter.writeEndObject();
    }

    public static KeywordMarkerTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (KeywordMarkerTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean keywordsFound = false;
            List keywords = null;
            String odataType = "#Microsoft.Azure.Search.KeywordMarkerTokenFilter";
            Boolean caseIgnored = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("keywords".equals(fieldName)) {
                    keywords = reader.readArray(reader1 -> reader1.getString());
                    keywordsFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("ignoreCase".equals(fieldName)) {
                    caseIgnored = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && keywordsFound) {
                KeywordMarkerTokenFilter deserializedKeywordMarkerTokenFilter = new KeywordMarkerTokenFilter(name, keywords);
                deserializedKeywordMarkerTokenFilter.odataType = odataType;
                deserializedKeywordMarkerTokenFilter.caseIgnored = caseIgnored;
                return deserializedKeywordMarkerTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!keywordsFound) {
                missingProperties.add("keywords");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

