/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.BM25SimilarityAlgorithm;
import com.azure.search.documents.indexes.models.ClassicSimilarityAlgorithm;
import java.io.IOException;

public class SimilarityAlgorithm
implements JsonSerializable<SimilarityAlgorithm> {
    private String odataType = "SimilarityAlgorithm";

    public String getOdataType() {
        return this.odataType;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static SimilarityAlgorithm fromJson(JsonReader jsonReader) throws IOException {
        return (SimilarityAlgorithm)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                SimilarityAlgorithm similarityAlgorithm;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("#Microsoft.Azure.Search.ClassicSimilarity".equals(discriminatorValue)) {
                    similarityAlgorithm = ClassicSimilarityAlgorithm.fromJson(readerToUse.reset());
                    return similarityAlgorithm;
                }
                if ("#Microsoft.Azure.Search.BM25Similarity".equals(discriminatorValue)) {
                    similarityAlgorithm = BM25SimilarityAlgorithm.fromJson(readerToUse.reset());
                    return similarityAlgorithm;
                }
                similarityAlgorithm = SimilarityAlgorithm.fromJsonKnownDiscriminator(readerToUse.reset());
                return similarityAlgorithm;
            }
        });
    }

    static SimilarityAlgorithm fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (SimilarityAlgorithm)jsonReader.readObject(reader -> {
            SimilarityAlgorithm deserializedSimilarityAlgorithm = new SimilarityAlgorithm();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    deserializedSimilarityAlgorithm.odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSimilarityAlgorithm;
        });
    }
}

