/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalAnalyzer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class StopAnalyzer
extends LexicalAnalyzer {
    private String odataType = "#Microsoft.Azure.Search.StopAnalyzer";
    private List<String> stopwords;

    public StopAnalyzer(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public List<String> getStopwords() {
        return this.stopwords;
    }

    public StopAnalyzer setStopwords(List<String> stopwords) {
        this.stopwords = stopwords;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeArrayField("stopwords", this.stopwords, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static StopAnalyzer fromJson(JsonReader jsonReader) throws IOException {
        return (StopAnalyzer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.StopAnalyzer";
            List stopwords = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("stopwords".equals(fieldName)) {
                    stopwords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                StopAnalyzer deserializedStopAnalyzer = new StopAnalyzer(name);
                deserializedStopAnalyzer.odataType = odataType;
                deserializedStopAnalyzer.stopwords = stopwords;
                return deserializedStopAnalyzer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }

    public StopAnalyzer setStopwords(String ... stopwords) {
        this.stopwords = stopwords == null ? null : Arrays.asList(stopwords);
        return this;
    }
}

