/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class TextWeights
implements JsonSerializable<TextWeights> {
    private final Map<String, Double> weights;

    public TextWeights(Map<String, Double> weights) {
        this.weights = weights;
    }

    public Map<String, Double> getWeights() {
        return this.weights;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("weights", this.weights, (writer, element) -> writer.writeDouble(element.doubleValue()));
        return jsonWriter.writeEndObject();
    }

    public static TextWeights fromJson(JsonReader jsonReader) throws IOException {
        return (TextWeights)jsonReader.readObject(reader -> {
            boolean weightsFound = false;
            Map weights = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("weights".equals(fieldName)) {
                    weights = reader.readMap(reader1 -> reader1.getDouble());
                    weightsFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (weightsFound) {
                return new TextWeights(weights);
            }
            throw new IllegalStateException("Missing required property: weights");
        });
    }
}

