/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;

public final class TruncateTokenFilter
extends TokenFilter {
    private String odataType = "#Microsoft.Azure.Search.TruncateTokenFilter";
    private Integer length;

    public TruncateTokenFilter(String name) {
        super(name);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public Integer getLength() {
        return this.length;
    }

    public TruncateTokenFilter setLength(Integer length) {
        this.length = length;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("length", (Number)this.length);
        return jsonWriter.writeEndObject();
    }

    public static TruncateTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (TruncateTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.TruncateTokenFilter";
            Integer length = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("length".equals(fieldName)) {
                    length = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                TruncateTokenFilter deserializedTruncateTokenFilter = new TruncateTokenFilter(name);
                deserializedTruncateTokenFilter.odataType = odataType;
                deserializedTruncateTokenFilter.length = length;
                return deserializedTruncateTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

