/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.AzureOpenAIModelName;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerDataIdentity;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class AzureOpenAIEmbeddingSkill
extends SearchIndexerSkill {
    private String odataType = "#Microsoft.Skills.Text.AzureOpenAIEmbeddingSkill";
    private Integer dimensions;
    private String resourceUrl;
    private String deploymentName;
    private String apiKey;
    private SearchIndexerDataIdentity authIdentity;
    private AzureOpenAIModelName modelName;

    public AzureOpenAIEmbeddingSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public AzureOpenAIEmbeddingSkill setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public AzureOpenAIEmbeddingSkill setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
        return this;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public AzureOpenAIEmbeddingSkill setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public AzureOpenAIEmbeddingSkill setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public SearchIndexerDataIdentity getAuthIdentity() {
        return this.authIdentity;
    }

    public AzureOpenAIEmbeddingSkill setAuthIdentity(SearchIndexerDataIdentity authIdentity) {
        this.authIdentity = authIdentity;
        return this;
    }

    public AzureOpenAIModelName getModelName() {
        return this.modelName;
    }

    public AzureOpenAIEmbeddingSkill setModelName(AzureOpenAIModelName modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public AzureOpenAIEmbeddingSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public AzureOpenAIEmbeddingSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureOpenAIEmbeddingSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("dimensions", (Number)this.dimensions);
        jsonWriter.writeStringField("resourceUri", this.resourceUrl);
        jsonWriter.writeStringField("deploymentId", this.deploymentName);
        jsonWriter.writeStringField("apiKey", this.apiKey);
        jsonWriter.writeJsonField("authIdentity", (JsonSerializable)this.authIdentity);
        jsonWriter.writeStringField("modelName", this.modelName == null ? null : this.modelName.toString());
        return jsonWriter.writeEndObject();
    }

    public static AzureOpenAIEmbeddingSkill fromJson(JsonReader jsonReader) throws IOException {
        return (AzureOpenAIEmbeddingSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String odataType = "#Microsoft.Skills.Text.AzureOpenAIEmbeddingSkill";
            Integer dimensions = null;
            String resourceUrl = null;
            String deploymentName = null;
            String apiKey = null;
            SearchIndexerDataIdentity authIdentity = null;
            AzureOpenAIModelName modelName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    dimensions = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("resourceUri".equals(fieldName)) {
                    resourceUrl = reader.getString();
                    continue;
                }
                if ("deploymentId".equals(fieldName)) {
                    deploymentName = reader.getString();
                    continue;
                }
                if ("apiKey".equals(fieldName)) {
                    apiKey = reader.getString();
                    continue;
                }
                if ("authIdentity".equals(fieldName)) {
                    authIdentity = SearchIndexerDataIdentity.fromJson(reader);
                    continue;
                }
                if ("modelName".equals(fieldName)) {
                    modelName = AzureOpenAIModelName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                AzureOpenAIEmbeddingSkill deserializedAzureOpenAIEmbeddingSkill = new AzureOpenAIEmbeddingSkill(inputs, outputs);
                deserializedAzureOpenAIEmbeddingSkill.setName(name);
                deserializedAzureOpenAIEmbeddingSkill.setDescription(description);
                deserializedAzureOpenAIEmbeddingSkill.setContext(context);
                deserializedAzureOpenAIEmbeddingSkill.odataType = odataType;
                deserializedAzureOpenAIEmbeddingSkill.dimensions = dimensions;
                deserializedAzureOpenAIEmbeddingSkill.resourceUrl = resourceUrl;
                deserializedAzureOpenAIEmbeddingSkill.deploymentName = deploymentName;
                deserializedAzureOpenAIEmbeddingSkill.apiKey = apiKey;
                deserializedAzureOpenAIEmbeddingSkill.authIdentity = authIdentity;
                deserializedAzureOpenAIEmbeddingSkill.modelName = modelName;
                return deserializedAzureOpenAIEmbeddingSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

