/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.ExhaustiveKnnAlgorithmConfiguration;
import com.azure.search.documents.indexes.models.HnswAlgorithmConfiguration;
import com.azure.search.documents.indexes.models.VectorSearchAlgorithmKind;
import java.io.IOException;

public class VectorSearchAlgorithmConfiguration
implements JsonSerializable<VectorSearchAlgorithmConfiguration> {
    private VectorSearchAlgorithmKind kind = VectorSearchAlgorithmKind.fromString("VectorSearchAlgorithmConfiguration");
    private final String name;

    public VectorSearchAlgorithmConfiguration(String name) {
        this.name = name;
    }

    public VectorSearchAlgorithmKind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static VectorSearchAlgorithmConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (VectorSearchAlgorithmConfiguration)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                VectorSearchAlgorithmConfiguration vectorSearchAlgorithmConfiguration;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("hnsw".equals(discriminatorValue)) {
                    vectorSearchAlgorithmConfiguration = HnswAlgorithmConfiguration.fromJson(readerToUse.reset());
                    return vectorSearchAlgorithmConfiguration;
                }
                if ("exhaustiveKnn".equals(discriminatorValue)) {
                    vectorSearchAlgorithmConfiguration = ExhaustiveKnnAlgorithmConfiguration.fromJson(readerToUse.reset());
                    return vectorSearchAlgorithmConfiguration;
                }
                vectorSearchAlgorithmConfiguration = VectorSearchAlgorithmConfiguration.fromJsonKnownDiscriminator(readerToUse.reset());
                return vectorSearchAlgorithmConfiguration;
            }
        });
    }

    static VectorSearchAlgorithmConfiguration fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (VectorSearchAlgorithmConfiguration)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            VectorSearchAlgorithmKind kind = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorSearchAlgorithmKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                VectorSearchAlgorithmConfiguration deserializedVectorSearchAlgorithmConfiguration = new VectorSearchAlgorithmConfiguration(name);
                deserializedVectorSearchAlgorithmConfiguration.kind = kind;
                return deserializedVectorSearchAlgorithmConfiguration;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

