// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SynonymMap;
import java.io.IOException;
import java.util.List;

/**
 * Response from a List SynonymMaps request. If successful, it includes the full definitions of all synonym maps.
 */
@Immutable
public final class ListSynonymMapsResult implements JsonSerializable<ListSynonymMapsResult> {
    /*
     * The synonym maps in the Search service.
     */
    private final List<SynonymMap> synonymMaps;

    /**
     * Creates an instance of ListSynonymMapsResult class.
     * 
     * @param synonymMaps the synonymMaps value to set.
     */
    public ListSynonymMapsResult(List<SynonymMap> synonymMaps) {
        this.synonymMaps = synonymMaps;
    }

    /**
     * Get the synonymMaps property: The synonym maps in the Search service.
     * 
     * @return the synonymMaps value.
     */
    public List<SynonymMap> getSynonymMaps() {
        return this.synonymMaps;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListSynonymMapsResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListSynonymMapsResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ListSynonymMapsResult.
     */
    public static ListSynonymMapsResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean synonymMapsFound = false;
            List<SynonymMap> synonymMaps = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    synonymMaps = reader.readArray(reader1 -> SynonymMap.fromJson(reader1));
                    synonymMapsFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (synonymMapsFound) {
                return new ListSynonymMapsResult(synonymMaps);
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}
