// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import java.io.IOException;

/**
 * Breaks text following the Unicode Text Segmentation rules. This tokenizer is implemented using Apache Lucene.
 */
@Fluent
public final class LuceneStandardTokenizerV1 extends LexicalTokenizer {
    /*
     * A URI fragment specifying the type of tokenizer.
     */
    private String odataType = "#Microsoft.Azure.Search.StandardTokenizer";

    /*
     * The maximum token length. Default is 255. Tokens longer than the maximum length are split.
     */
    private Integer maxTokenLength;

    /**
     * Creates an instance of LuceneStandardTokenizerV1 class.
     * 
     * @param name the name value to set.
     */
    public LuceneStandardTokenizerV1(String name) {
        super(name);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of tokenizer.
     * 
     * @return the odataType value.
     */
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the maxTokenLength property: The maximum token length. Default is 255. Tokens longer than the maximum length
     * are split.
     * 
     * @return the maxTokenLength value.
     */
    public Integer getMaxTokenLength() {
        return this.maxTokenLength;
    }

    /**
     * Set the maxTokenLength property: The maximum token length. Default is 255. Tokens longer than the maximum length
     * are split.
     * 
     * @param maxTokenLength the maxTokenLength value to set.
     * @return the LuceneStandardTokenizerV1 object itself.
     */
    public LuceneStandardTokenizerV1 setMaxTokenLength(Integer maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("maxTokenLength", this.maxTokenLength);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LuceneStandardTokenizerV1 from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LuceneStandardTokenizerV1 if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LuceneStandardTokenizerV1.
     */
    public static LuceneStandardTokenizerV1 fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.StandardTokenizer";
            Integer maxTokenLength = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("maxTokenLength".equals(fieldName)) {
                    maxTokenLength = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                LuceneStandardTokenizerV1 deserializedLuceneStandardTokenizerV1 = new LuceneStandardTokenizerV1(name);
                deserializedLuceneStandardTokenizerV1.odataType = odataType;
                deserializedLuceneStandardTokenizerV1.maxTokenLength = maxTokenLength;

                return deserializedLuceneStandardTokenizerV1;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
