// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Allows you to generate a vector embedding for a given text input using the Azure OpenAI resource.
 */
@Fluent
public final class AzureOpenAIEmbeddingSkill extends SearchIndexerSkill {
    /*
     * A URI fragment specifying the type of skill.
     */
    private String odataType = "#Microsoft.Skills.Text.AzureOpenAIEmbeddingSkill";

    /*
     * The number of dimensions the resulting output embeddings should have. Only supported in text-embedding-3 and
     * later models.
     */
    private Integer dimensions;

    /*
     * The resource URI of the Azure OpenAI resource.
     */
    private String resourceUrl;

    /*
     * ID of the Azure OpenAI model deployment on the designated resource.
     */
    private String deploymentName;

    /*
     * API key of the designated Azure OpenAI resource.
     */
    private String apiKey;

    /*
     * The user-assigned managed identity used for outbound connections.
     */
    private SearchIndexerDataIdentity authIdentity;

    /*
     * The name of the embedding model that is deployed at the provided deploymentId path.
     */
    private AzureOpenAIModelName modelName;

    /**
     * Creates an instance of AzureOpenAIEmbeddingSkill class.
     * 
     * @param inputs the inputs value to set.
     * @param outputs the outputs value to set.
     */
    public AzureOpenAIEmbeddingSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of skill.
     * 
     * @return the odataType value.
     */
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the dimensions property: The number of dimensions the resulting output embeddings should have. Only supported
     * in text-embedding-3 and later models.
     * 
     * @return the dimensions value.
     */
    public Integer getDimensions() {
        return this.dimensions;
    }

    /**
     * Set the dimensions property: The number of dimensions the resulting output embeddings should have. Only supported
     * in text-embedding-3 and later models.
     * 
     * @param dimensions the dimensions value to set.
     * @return the AzureOpenAIEmbeddingSkill object itself.
     */
    public AzureOpenAIEmbeddingSkill setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    /**
     * Get the resourceUrl property: The resource URI of the Azure OpenAI resource.
     * 
     * @return the resourceUrl value.
     */
    public String getResourceUrl() {
        return this.resourceUrl;
    }

    /**
     * Set the resourceUrl property: The resource URI of the Azure OpenAI resource.
     * 
     * @param resourceUrl the resourceUrl value to set.
     * @return the AzureOpenAIEmbeddingSkill object itself.
     */
    public AzureOpenAIEmbeddingSkill setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
        return this;
    }

    /**
     * Get the deploymentName property: ID of the Azure OpenAI model deployment on the designated resource.
     * 
     * @return the deploymentName value.
     */
    public String getDeploymentName() {
        return this.deploymentName;
    }

    /**
     * Set the deploymentName property: ID of the Azure OpenAI model deployment on the designated resource.
     * 
     * @param deploymentName the deploymentName value to set.
     * @return the AzureOpenAIEmbeddingSkill object itself.
     */
    public AzureOpenAIEmbeddingSkill setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    /**
     * Get the apiKey property: API key of the designated Azure OpenAI resource.
     * 
     * @return the apiKey value.
     */
    public String getApiKey() {
        return this.apiKey;
    }

    /**
     * Set the apiKey property: API key of the designated Azure OpenAI resource.
     * 
     * @param apiKey the apiKey value to set.
     * @return the AzureOpenAIEmbeddingSkill object itself.
     */
    public AzureOpenAIEmbeddingSkill setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    /**
     * Get the authIdentity property: The user-assigned managed identity used for outbound connections.
     * 
     * @return the authIdentity value.
     */
    public SearchIndexerDataIdentity getAuthIdentity() {
        return this.authIdentity;
    }

    /**
     * Set the authIdentity property: The user-assigned managed identity used for outbound connections.
     * 
     * @param authIdentity the authIdentity value to set.
     * @return the AzureOpenAIEmbeddingSkill object itself.
     */
    public AzureOpenAIEmbeddingSkill setAuthIdentity(SearchIndexerDataIdentity authIdentity) {
        this.authIdentity = authIdentity;
        return this;
    }

    /**
     * Get the modelName property: The name of the embedding model that is deployed at the provided deploymentId path.
     * 
     * @return the modelName value.
     */
    public AzureOpenAIModelName getModelName() {
        return this.modelName;
    }

    /**
     * Set the modelName property: The name of the embedding model that is deployed at the provided deploymentId path.
     * 
     * @param modelName the modelName value to set.
     * @return the AzureOpenAIEmbeddingSkill object itself.
     */
    public AzureOpenAIEmbeddingSkill setModelName(AzureOpenAIModelName modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureOpenAIEmbeddingSkill setName(String name) {
        super.setName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureOpenAIEmbeddingSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureOpenAIEmbeddingSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("outputs", getOutputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("context", getContext());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("dimensions", this.dimensions);
        jsonWriter.writeStringField("resourceUri", this.resourceUrl);
        jsonWriter.writeStringField("deploymentId", this.deploymentName);
        jsonWriter.writeStringField("apiKey", this.apiKey);
        jsonWriter.writeJsonField("authIdentity", this.authIdentity);
        jsonWriter.writeStringField("modelName", this.modelName == null ? null : this.modelName.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureOpenAIEmbeddingSkill from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureOpenAIEmbeddingSkill if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureOpenAIEmbeddingSkill.
     */
    public static AzureOpenAIEmbeddingSkill fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List<InputFieldMappingEntry> inputs = null;
            boolean outputsFound = false;
            List<OutputFieldMappingEntry> outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String odataType = "#Microsoft.Skills.Text.AzureOpenAIEmbeddingSkill";
            Integer dimensions = null;
            String resourceUrl = null;
            String deploymentName = null;
            String apiKey = null;
            SearchIndexerDataIdentity authIdentity = null;
            AzureOpenAIModelName modelName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                } else if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("context".equals(fieldName)) {
                    context = reader.getString();
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("dimensions".equals(fieldName)) {
                    dimensions = reader.getNullable(JsonReader::getInt);
                } else if ("resourceUri".equals(fieldName)) {
                    resourceUrl = reader.getString();
                } else if ("deploymentId".equals(fieldName)) {
                    deploymentName = reader.getString();
                } else if ("apiKey".equals(fieldName)) {
                    apiKey = reader.getString();
                } else if ("authIdentity".equals(fieldName)) {
                    authIdentity = SearchIndexerDataIdentity.fromJson(reader);
                } else if ("modelName".equals(fieldName)) {
                    modelName = AzureOpenAIModelName.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (inputsFound && outputsFound) {
                AzureOpenAIEmbeddingSkill deserializedAzureOpenAIEmbeddingSkill
                    = new AzureOpenAIEmbeddingSkill(inputs, outputs);
                deserializedAzureOpenAIEmbeddingSkill.setName(name);
                deserializedAzureOpenAIEmbeddingSkill.setDescription(description);
                deserializedAzureOpenAIEmbeddingSkill.setContext(context);
                deserializedAzureOpenAIEmbeddingSkill.odataType = odataType;
                deserializedAzureOpenAIEmbeddingSkill.dimensions = dimensions;
                deserializedAzureOpenAIEmbeddingSkill.resourceUrl = resourceUrl;
                deserializedAzureOpenAIEmbeddingSkill.deploymentName = deploymentName;
                deserializedAzureOpenAIEmbeddingSkill.apiKey = apiKey;
                deserializedAzureOpenAIEmbeddingSkill.authIdentity = authIdentity;
                deserializedAzureOpenAIEmbeddingSkill.modelName = modelName;

                return deserializedAzureOpenAIEmbeddingSkill;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
