// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The Azure Open AI model name that will be called.
 */
public final class AzureOpenAIModelName extends ExpandableStringEnum<AzureOpenAIModelName> {

    /**
     * Static value text-embedding-ada-002 for AzureOpenAIModelName.
     */
    public static final AzureOpenAIModelName TEXT_EMBEDDING_ADA_002 = fromString("text-embedding-ada-002");

    /**
     * Static value text-embedding-3-large for AzureOpenAIModelName.
     */
    public static final AzureOpenAIModelName TEXT_EMBEDDING_3_LARGE = fromString("text-embedding-3-large");

    /**
     * Static value text-embedding-3-small for AzureOpenAIModelName.
     */
    public static final AzureOpenAIModelName TEXT_EMBEDDING_3_SMALL = fromString("text-embedding-3-small");

    /**
     * Creates a new instance of AzureOpenAIModelName value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AzureOpenAIModelName() {
    }

    /**
     * Creates or finds a AzureOpenAIModelName from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AzureOpenAIModelName.
     */
    public static AzureOpenAIModelName fromString(String name) {
        return fromString(name, AzureOpenAIModelName.class);
    }

    /**
     * Gets known AzureOpenAIModelName values.
     *
     * @return known AzureOpenAIModelName values.
     */
    public static Collection<AzureOpenAIModelName> values() {
        return values(AzureOpenAIModelName.class);
    }
}
