// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Arrays;

/**
 * Removes elisions. For example, "l'avion" (the plane) will be converted to "avion" (plane). This token filter is
 * implemented using Apache Lucene.
 */
@Fluent
public final class ElisionTokenFilter extends TokenFilter {

    /*
     * A URI fragment specifying the type of token filter.
     */
    private String odataType = "#Microsoft.Azure.Search.ElisionTokenFilter";

    /*
     * The set of articles to remove.
     */
    private List<String> articles;

    /**
     * Creates an instance of ElisionTokenFilter class.
     *
     * @param name the name value to set.
     */
    public ElisionTokenFilter(String name) {
        super(name);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of token filter.
     *
     * @return the odataType value.
     */
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the articles property: The set of articles to remove.
     *
     * @return the articles value.
     */
    public List<String> getArticles() {
        return this.articles;
    }

    /**
     * Set the articles property: The set of articles to remove.
     *
     * @param articles the articles value to set.
     * @return the ElisionTokenFilter object itself.
     */
    public ElisionTokenFilter setArticles(List<String> articles) {
        this.articles = articles;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeArrayField("articles", this.articles, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ElisionTokenFilter from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ElisionTokenFilter if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ElisionTokenFilter.
     */
    public static ElisionTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.ElisionTokenFilter";
            List<String> articles = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("articles".equals(fieldName)) {
                    articles = reader.readArray(reader1 -> reader1.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                ElisionTokenFilter deserializedElisionTokenFilter = new ElisionTokenFilter(name);
                deserializedElisionTokenFilter.odataType = odataType;
                deserializedElisionTokenFilter.articles = articles;
                return deserializedElisionTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }

    /**
     * Set the articles property: The set of articles to remove.
     *
     * @param articles the articles value to set.
     * @return the ElisionTokenFilter object itself.
     */
    public ElisionTokenFilter setArticles(String... articles) {
        this.articles = (articles == null) ? null : Arrays.asList(articles);
        return this;
    }
}
