// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Divides text using language-specific rules.
 */
@Fluent
public final class MicrosoftLanguageTokenizer extends LexicalTokenizer {
    /*
     * A URI fragment specifying the type of tokenizer.
     */
    private String odataType = "#Microsoft.Azure.Search.MicrosoftLanguageTokenizer";

    /*
     * The maximum token length. Tokens longer than the maximum length are split. Maximum token length that can be used
     * is 300 characters. Tokens longer than 300 characters are first split into tokens of length 300 and then each of
     * those tokens is split based on the max token length set. Default is 255.
     */
    private Integer maxTokenLength;

    /*
     * A value indicating how the tokenizer is used. Set to true if used as the search tokenizer, set to false if used
     * as the indexing tokenizer. Default is false.
     */
    private Boolean isSearchTokenizer;

    /*
     * The language to use. The default is English.
     */
    private MicrosoftTokenizerLanguage language;

    /**
     * Creates an instance of MicrosoftLanguageTokenizer class.
     * 
     * @param name the name value to set.
     */
    public MicrosoftLanguageTokenizer(String name) {
        super(name);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of tokenizer.
     * 
     * @return the odataType value.
     */
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the maxTokenLength property: The maximum token length. Tokens longer than the maximum length are split.
     * Maximum token length that can be used is 300 characters. Tokens longer than 300 characters are first split into
     * tokens of length 300 and then each of those tokens is split based on the max token length set. Default is 255.
     * 
     * @return the maxTokenLength value.
     */
    public Integer getMaxTokenLength() {
        return this.maxTokenLength;
    }

    /**
     * Set the maxTokenLength property: The maximum token length. Tokens longer than the maximum length are split.
     * Maximum token length that can be used is 300 characters. Tokens longer than 300 characters are first split into
     * tokens of length 300 and then each of those tokens is split based on the max token length set. Default is 255.
     * 
     * @param maxTokenLength the maxTokenLength value to set.
     * @return the MicrosoftLanguageTokenizer object itself.
     */
    public MicrosoftLanguageTokenizer setMaxTokenLength(Integer maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
        return this;
    }

    /**
     * Get the isSearchTokenizer property: A value indicating how the tokenizer is used. Set to true if used as the
     * search tokenizer, set to false if used as the indexing tokenizer. Default is false.
     * 
     * @return the isSearchTokenizer value.
     */
    public Boolean isSearchTokenizer() {
        return this.isSearchTokenizer;
    }

    /**
     * Set the isSearchTokenizer property: A value indicating how the tokenizer is used. Set to true if used as the
     * search tokenizer, set to false if used as the indexing tokenizer. Default is false.
     * 
     * @param isSearchTokenizer the isSearchTokenizer value to set.
     * @return the MicrosoftLanguageTokenizer object itself.
     */
    public MicrosoftLanguageTokenizer setIsSearchTokenizer(Boolean isSearchTokenizer) {
        this.isSearchTokenizer = isSearchTokenizer;
        return this;
    }

    /**
     * Get the language property: The language to use. The default is English.
     * 
     * @return the language value.
     */
    public MicrosoftTokenizerLanguage getLanguage() {
        return this.language;
    }

    /**
     * Set the language property: The language to use. The default is English.
     * 
     * @param language the language value to set.
     * @return the MicrosoftLanguageTokenizer object itself.
     */
    public MicrosoftLanguageTokenizer setLanguage(MicrosoftTokenizerLanguage language) {
        this.language = language;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("maxTokenLength", this.maxTokenLength);
        jsonWriter.writeBooleanField("isSearchTokenizer", this.isSearchTokenizer);
        jsonWriter.writeStringField("language", this.language == null ? null : this.language.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftLanguageTokenizer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftLanguageTokenizer if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MicrosoftLanguageTokenizer.
     */
    public static MicrosoftLanguageTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.MicrosoftLanguageTokenizer";
            Integer maxTokenLength = null;
            Boolean isSearchTokenizer = null;
            MicrosoftTokenizerLanguage language = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("maxTokenLength".equals(fieldName)) {
                    maxTokenLength = reader.getNullable(JsonReader::getInt);
                } else if ("isSearchTokenizer".equals(fieldName)) {
                    isSearchTokenizer = reader.getNullable(JsonReader::getBoolean);
                } else if ("language".equals(fieldName)) {
                    language = MicrosoftTokenizerLanguage.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                MicrosoftLanguageTokenizer deserializedMicrosoftLanguageTokenizer
                    = new MicrosoftLanguageTokenizer(name);
                deserializedMicrosoftLanguageTokenizer.odataType = odataType;
                deserializedMicrosoftLanguageTokenizer.maxTokenLength = maxTokenLength;
                deserializedMicrosoftLanguageTokenizer.isSearchTokenizer = isSearchTokenizer;
                deserializedMicrosoftLanguageTokenizer.language = language;

                return deserializedMicrosoftLanguageTokenizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
