// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Arrays;

/**
 * Tokenizes the input into n-grams of the given size(s). This tokenizer is implemented using Apache Lucene.
 */
@Fluent
public final class NGramTokenizer extends LexicalTokenizer {

    /*
     * A URI fragment specifying the type of tokenizer.
     */
    private String odataType = "#Microsoft.Azure.Search.NGramTokenizer";

    /*
     * The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the value of maxGram.
     */
    private Integer minGram;

    /*
     * The maximum n-gram length. Default is 2. Maximum is 300.
     */
    private Integer maxGram;

    /*
     * Character classes to keep in the tokens.
     */
    private List<TokenCharacterKind> tokenChars;

    /**
     * Creates an instance of NGramTokenizer class.
     *
     * @param name the name value to set.
     */
    public NGramTokenizer(String name) {
        super(name);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of tokenizer.
     *
     * @return the odataType value.
     */
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the minGram property: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the value of
     * maxGram.
     *
     * @return the minGram value.
     */
    public Integer getMinGram() {
        return this.minGram;
    }

    /**
     * Set the minGram property: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the value of
     * maxGram.
     *
     * @param minGram the minGram value to set.
     * @return the NGramTokenizer object itself.
     */
    public NGramTokenizer setMinGram(Integer minGram) {
        this.minGram = minGram;
        return this;
    }

    /**
     * Get the maxGram property: The maximum n-gram length. Default is 2. Maximum is 300.
     *
     * @return the maxGram value.
     */
    public Integer getMaxGram() {
        return this.maxGram;
    }

    /**
     * Set the maxGram property: The maximum n-gram length. Default is 2. Maximum is 300.
     *
     * @param maxGram the maxGram value to set.
     * @return the NGramTokenizer object itself.
     */
    public NGramTokenizer setMaxGram(Integer maxGram) {
        this.maxGram = maxGram;
        return this;
    }

    /**
     * Get the tokenChars property: Character classes to keep in the tokens.
     *
     * @return the tokenChars value.
     */
    public List<TokenCharacterKind> getTokenChars() {
        return this.tokenChars;
    }

    /**
     * Set the tokenChars property: Character classes to keep in the tokens.
     *
     * @param tokenChars the tokenChars value to set.
     * @return the NGramTokenizer object itself.
     */
    public NGramTokenizer setTokenChars(List<TokenCharacterKind> tokenChars) {
        this.tokenChars = tokenChars;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("minGram", this.minGram);
        jsonWriter.writeNumberField("maxGram", this.maxGram);
        jsonWriter.writeArrayField("tokenChars", this.tokenChars,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NGramTokenizer from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of NGramTokenizer if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NGramTokenizer.
     */
    public static NGramTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.NGramTokenizer";
            Integer minGram = null;
            Integer maxGram = null;
            List<TokenCharacterKind> tokenChars = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("minGram".equals(fieldName)) {
                    minGram = reader.getNullable(JsonReader::getInt);
                } else if ("maxGram".equals(fieldName)) {
                    maxGram = reader.getNullable(JsonReader::getInt);
                } else if ("tokenChars".equals(fieldName)) {
                    tokenChars = reader.readArray(reader1 -> TokenCharacterKind.fromString(reader1.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                NGramTokenizer deserializedNGramTokenizer = new NGramTokenizer(name);
                deserializedNGramTokenizer.odataType = odataType;
                deserializedNGramTokenizer.minGram = minGram;
                deserializedNGramTokenizer.maxGram = maxGram;
                deserializedNGramTokenizer.tokenChars = tokenChars;
                return deserializedNGramTokenizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }

    /**
     * Set the tokenChars property: Character classes to keep in the tokens.
     *
     * @param tokenChars the tokenChars value to set.
     * @return the NGramTokenizer object itself.
     */
    public NGramTokenizer setTokenChars(TokenCharacterKind... tokenChars) {
        this.tokenChars = (tokenChars == null) ? null : Arrays.asList(tokenChars);
        return this;
    }
}
