// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains configuration options specific to the scalar quantization compression method used during indexing and
 * querying.
 */
@Fluent
public final class ScalarQuantizationCompression extends VectorSearchCompression {
    /*
     * The name of the kind of compression method being configured for use with vector search.
     */
    private VectorSearchCompressionKind kind = VectorSearchCompressionKind.SCALAR_QUANTIZATION;

    /*
     * Contains the parameters specific to Scalar Quantization.
     */
    private ScalarQuantizationParameters parameters;

    /**
     * Creates an instance of ScalarQuantizationCompression class.
     * 
     * @param compressionName the compressionName value to set.
     */
    public ScalarQuantizationCompression(String compressionName) {
        super(compressionName);
    }

    /**
     * Get the kind property: The name of the kind of compression method being configured for use with vector search.
     * 
     * @return the kind value.
     */
    @Override
    public VectorSearchCompressionKind getKind() {
        return this.kind;
    }

    /**
     * Get the parameters property: Contains the parameters specific to Scalar Quantization.
     * 
     * @return the parameters value.
     */
    public ScalarQuantizationParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Contains the parameters specific to Scalar Quantization.
     * 
     * @param parameters the parameters value to set.
     * @return the ScalarQuantizationCompression object itself.
     */
    public ScalarQuantizationCompression setParameters(ScalarQuantizationParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScalarQuantizationCompression setRerankWithOriginalVectors(Boolean rerankWithOriginalVectors) {
        super.setRerankWithOriginalVectors(rerankWithOriginalVectors);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ScalarQuantizationCompression setDefaultOversampling(Double defaultOversampling) {
        super.setDefaultOversampling(defaultOversampling);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getCompressionName());
        jsonWriter.writeBooleanField("rerankWithOriginalVectors", isRerankWithOriginalVectors());
        jsonWriter.writeNumberField("defaultOversampling", getDefaultOversampling());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("scalarQuantizationParameters", this.parameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScalarQuantizationCompression from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScalarQuantizationCompression if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ScalarQuantizationCompression.
     */
    public static ScalarQuantizationCompression fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean compressionNameFound = false;
            String compressionName = null;
            Boolean rerankWithOriginalVectors = null;
            Double defaultOversampling = null;
            VectorSearchCompressionKind kind = VectorSearchCompressionKind.SCALAR_QUANTIZATION;
            ScalarQuantizationParameters parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    compressionName = reader.getString();
                    compressionNameFound = true;
                } else if ("rerankWithOriginalVectors".equals(fieldName)) {
                    rerankWithOriginalVectors = reader.getNullable(JsonReader::getBoolean);
                } else if ("defaultOversampling".equals(fieldName)) {
                    defaultOversampling = reader.getNullable(JsonReader::getDouble);
                } else if ("kind".equals(fieldName)) {
                    kind = VectorSearchCompressionKind.fromString(reader.getString());
                } else if ("scalarQuantizationParameters".equals(fieldName)) {
                    parameters = ScalarQuantizationParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (compressionNameFound) {
                ScalarQuantizationCompression deserializedScalarQuantizationCompression
                    = new ScalarQuantizationCompression(compressionName);
                deserializedScalarQuantizationCompression.setRerankWithOriginalVectors(rerankWithOriginalVectors);
                deserializedScalarQuantizationCompression.setDefaultOversampling(defaultOversampling);
                deserializedScalarQuantizationCompression.kind = kind;
                deserializedScalarQuantizationCompression.parameters = parameters;

                return deserializedScalarQuantizationCompression;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
