// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * A dictionary of index projection-specific configuration properties. Each name is the name of a specific property.
 * Each value must be of a primitive type.
 */
@Fluent
public final class SearchIndexerIndexProjectionsParameters
    implements JsonSerializable<SearchIndexerIndexProjectionsParameters> {
    /*
     * Defines behavior of the index projections in relation to the rest of the indexer.
     */
    private IndexProjectionMode projectionMode;

    /*
     * A dictionary of index projection-specific configuration properties. Each name is the name of a specific property.
     * Each value must be of a primitive type.
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of SearchIndexerIndexProjectionsParameters class.
     */
    public SearchIndexerIndexProjectionsParameters() {
    }

    /**
     * Get the projectionMode property: Defines behavior of the index projections in relation to the rest of the
     * indexer.
     * 
     * @return the projectionMode value.
     */
    public IndexProjectionMode getProjectionMode() {
        return this.projectionMode;
    }

    /**
     * Set the projectionMode property: Defines behavior of the index projections in relation to the rest of the
     * indexer.
     * 
     * @param projectionMode the projectionMode value to set.
     * @return the SearchIndexerIndexProjectionsParameters object itself.
     */
    public SearchIndexerIndexProjectionsParameters setProjectionMode(IndexProjectionMode projectionMode) {
        this.projectionMode = projectionMode;
        return this;
    }

    /**
     * Get the additionalProperties property: A dictionary of index projection-specific configuration properties. Each
     * name is the name of a specific property. Each value must be of a primitive type.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: A dictionary of index projection-specific configuration properties. Each
     * name is the name of a specific property. Each value must be of a primitive type.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the SearchIndexerIndexProjectionsParameters object itself.
     */
    public SearchIndexerIndexProjectionsParameters setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("projectionMode",
            this.projectionMode == null ? null : this.projectionMode.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexerIndexProjectionsParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexerIndexProjectionsParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SearchIndexerIndexProjectionsParameters.
     */
    public static SearchIndexerIndexProjectionsParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchIndexerIndexProjectionsParameters deserializedSearchIndexerIndexProjectionsParameters
                = new SearchIndexerIndexProjectionsParameters();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("projectionMode".equals(fieldName)) {
                    deserializedSearchIndexerIndexProjectionsParameters.projectionMode
                        = IndexProjectionMode.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedSearchIndexerIndexProjectionsParameters.additionalProperties = additionalProperties;

            return deserializedSearchIndexerIndexProjectionsParameters;
        });
    }
}
