// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Represents the current status and execution history of an indexer.
 */
@Immutable
public final class SearchIndexerStatus implements JsonSerializable<SearchIndexerStatus> {
    /*
     * Overall indexer status.
     */
    private final IndexerStatus status;

    /*
     * The result of the most recent or an in-progress indexer execution.
     */
    private IndexerExecutionResult lastResult;

    /*
     * History of the recent indexer executions, sorted in reverse chronological order.
     */
    private final List<IndexerExecutionResult> executionHistory;

    /*
     * The execution limits for the indexer.
     */
    private final SearchIndexerLimits limits;

    /**
     * Creates an instance of SearchIndexerStatus class.
     * 
     * @param status the status value to set.
     * @param executionHistory the executionHistory value to set.
     * @param limits the limits value to set.
     */
    public SearchIndexerStatus(IndexerStatus status, List<IndexerExecutionResult> executionHistory,
        SearchIndexerLimits limits) {
        this.status = status;
        this.executionHistory = executionHistory;
        this.limits = limits;
    }

    /**
     * Get the status property: Overall indexer status.
     * 
     * @return the status value.
     */
    public IndexerStatus getStatus() {
        return this.status;
    }

    /**
     * Get the lastResult property: The result of the most recent or an in-progress indexer execution.
     * 
     * @return the lastResult value.
     */
    public IndexerExecutionResult getLastResult() {
        return this.lastResult;
    }

    /**
     * Get the executionHistory property: History of the recent indexer executions, sorted in reverse chronological
     * order.
     * 
     * @return the executionHistory value.
     */
    public List<IndexerExecutionResult> getExecutionHistory() {
        return this.executionHistory;
    }

    /**
     * Get the limits property: The execution limits for the indexer.
     * 
     * @return the limits value.
     */
    public SearchIndexerLimits getLimits() {
        return this.limits;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexerStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexerStatus if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SearchIndexerStatus.
     */
    public static SearchIndexerStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean statusFound = false;
            IndexerStatus status = null;
            boolean executionHistoryFound = false;
            List<IndexerExecutionResult> executionHistory = null;
            boolean limitsFound = false;
            SearchIndexerLimits limits = null;
            IndexerExecutionResult lastResult = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    status = IndexerStatus.fromString(reader.getString());
                    statusFound = true;
                } else if ("executionHistory".equals(fieldName)) {
                    executionHistory = reader.readArray(reader1 -> IndexerExecutionResult.fromJson(reader1));
                    executionHistoryFound = true;
                } else if ("limits".equals(fieldName)) {
                    limits = SearchIndexerLimits.fromJson(reader);
                    limitsFound = true;
                } else if ("lastResult".equals(fieldName)) {
                    lastResult = IndexerExecutionResult.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (statusFound && executionHistoryFound && limitsFound) {
                SearchIndexerStatus deserializedSearchIndexerStatus
                    = new SearchIndexerStatus(status, executionHistory, limits);
                deserializedSearchIndexerStatus.lastResult = lastResult;

                return deserializedSearchIndexerStatus;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!statusFound) {
                missingProperties.add("status");
            }
            if (!executionHistoryFound) {
                missingProperties.add("executionHistory");
            }
            if (!limitsFound) {
                missingProperties.add("limits");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
