// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Truncates the terms to a specific length. This token filter is implemented using Apache Lucene.
 */
@Fluent
public final class TruncateTokenFilter extends TokenFilter {
    /*
     * A URI fragment specifying the type of token filter.
     */
    private String odataType = "#Microsoft.Azure.Search.TruncateTokenFilter";

    /*
     * The length at which terms will be truncated. Default and maximum is 300.
     */
    private Integer length;

    /**
     * Creates an instance of TruncateTokenFilter class.
     * 
     * @param name the name value to set.
     */
    public TruncateTokenFilter(String name) {
        super(name);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of token filter.
     * 
     * @return the odataType value.
     */
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the length property: The length at which terms will be truncated. Default and maximum is 300.
     * 
     * @return the length value.
     */
    public Integer getLength() {
        return this.length;
    }

    /**
     * Set the length property: The length at which terms will be truncated. Default and maximum is 300.
     * 
     * @param length the length value to set.
     * @return the TruncateTokenFilter object itself.
     */
    public TruncateTokenFilter setLength(Integer length) {
        this.length = length;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeNumberField("length", this.length);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TruncateTokenFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TruncateTokenFilter if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TruncateTokenFilter.
     */
    public static TruncateTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.TruncateTokenFilter";
            Integer length = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("length".equals(fieldName)) {
                    length = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                TruncateTokenFilter deserializedTruncateTokenFilter = new TruncateTokenFilter(name);
                deserializedTruncateTokenFilter.odataType = odataType;
                deserializedTruncateTokenFilter.length = length;

                return deserializedTruncateTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
