// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains configuration options specific to the compression method used during indexing or querying.
 */
@Fluent
public class VectorSearchCompression implements JsonSerializable<VectorSearchCompression> {
    /*
     * The name of the kind of compression method being configured for use with vector search.
     */
    private VectorSearchCompressionKind kind = VectorSearchCompressionKind.fromString("VectorSearchCompression");

    /*
     * The name to associate with this particular configuration.
     */
    private final String compressionName;

    /*
     * If set to true, once the ordered set of results calculated using compressed vectors are obtained, they will be
     * reranked again by recalculating the full-precision similarity scores. This will improve recall at the expense of
     * latency.
     */
    private Boolean rerankWithOriginalVectors;

    /*
     * Default oversampling factor. Oversampling will internally request more documents (specified by this multiplier)
     * in the initial search. This increases the set of results that will be reranked using recomputed similarity scores
     * from full-precision vectors. Minimum value is 1, meaning no oversampling (1x). This parameter can only be set
     * when rerankWithOriginalVectors is true. Higher values improve recall at the expense of latency.
     */
    private Double defaultOversampling;

    /**
     * Creates an instance of VectorSearchCompression class.
     * 
     * @param compressionName the compressionName value to set.
     */
    public VectorSearchCompression(String compressionName) {
        this.compressionName = compressionName;
    }

    /**
     * Get the kind property: The name of the kind of compression method being configured for use with vector search.
     * 
     * @return the kind value.
     */
    public VectorSearchCompressionKind getKind() {
        return this.kind;
    }

    /**
     * Get the compressionName property: The name to associate with this particular configuration.
     * 
     * @return the compressionName value.
     */
    public String getCompressionName() {
        return this.compressionName;
    }

    /**
     * Get the rerankWithOriginalVectors property: If set to true, once the ordered set of results calculated using
     * compressed vectors are obtained, they will be reranked again by recalculating the full-precision similarity
     * scores. This will improve recall at the expense of latency.
     * 
     * @return the rerankWithOriginalVectors value.
     */
    public Boolean isRerankWithOriginalVectors() {
        return this.rerankWithOriginalVectors;
    }

    /**
     * Set the rerankWithOriginalVectors property: If set to true, once the ordered set of results calculated using
     * compressed vectors are obtained, they will be reranked again by recalculating the full-precision similarity
     * scores. This will improve recall at the expense of latency.
     * 
     * @param rerankWithOriginalVectors the rerankWithOriginalVectors value to set.
     * @return the VectorSearchCompression object itself.
     */
    public VectorSearchCompression setRerankWithOriginalVectors(Boolean rerankWithOriginalVectors) {
        this.rerankWithOriginalVectors = rerankWithOriginalVectors;
        return this;
    }

    /**
     * Get the defaultOversampling property: Default oversampling factor. Oversampling will internally request more
     * documents (specified by this multiplier) in the initial search. This increases the set of results that will be
     * reranked using recomputed similarity scores from full-precision vectors. Minimum value is 1, meaning no
     * oversampling (1x). This parameter can only be set when rerankWithOriginalVectors is true. Higher values improve
     * recall at the expense of latency.
     * 
     * @return the defaultOversampling value.
     */
    public Double getDefaultOversampling() {
        return this.defaultOversampling;
    }

    /**
     * Set the defaultOversampling property: Default oversampling factor. Oversampling will internally request more
     * documents (specified by this multiplier) in the initial search. This increases the set of results that will be
     * reranked using recomputed similarity scores from full-precision vectors. Minimum value is 1, meaning no
     * oversampling (1x). This parameter can only be set when rerankWithOriginalVectors is true. Higher values improve
     * recall at the expense of latency.
     * 
     * @param defaultOversampling the defaultOversampling value to set.
     * @return the VectorSearchCompression object itself.
     */
    public VectorSearchCompression setDefaultOversampling(Double defaultOversampling) {
        this.defaultOversampling = defaultOversampling;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.compressionName);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeBooleanField("rerankWithOriginalVectors", this.rerankWithOriginalVectors);
        jsonWriter.writeNumberField("defaultOversampling", this.defaultOversampling);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorSearchCompression from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorSearchCompression if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorSearchCompression.
     */
    public static VectorSearchCompression fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("scalarQuantization".equals(discriminatorValue)) {
                    return ScalarQuantizationCompression.fromJson(readerToUse.reset());
                } else if ("binaryQuantization".equals(discriminatorValue)) {
                    return BinaryQuantizationCompression.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static VectorSearchCompression fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean compressionNameFound = false;
            String compressionName = null;
            VectorSearchCompressionKind kind = null;
            Boolean rerankWithOriginalVectors = null;
            Double defaultOversampling = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    compressionName = reader.getString();
                    compressionNameFound = true;
                } else if ("kind".equals(fieldName)) {
                    kind = VectorSearchCompressionKind.fromString(reader.getString());
                } else if ("rerankWithOriginalVectors".equals(fieldName)) {
                    rerankWithOriginalVectors = reader.getNullable(JsonReader::getBoolean);
                } else if ("defaultOversampling".equals(fieldName)) {
                    defaultOversampling = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }
            if (compressionNameFound) {
                VectorSearchCompression deserializedVectorSearchCompression
                    = new VectorSearchCompression(compressionName);
                deserializedVectorSearchCompression.kind = kind;
                deserializedVectorSearchCompression.rerankWithOriginalVectors = rerankWithOriginalVectors;
                deserializedVectorSearchCompression.defaultOversampling = defaultOversampling;

                return deserializedVectorSearchCompression;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
