/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.azure.search.documents.SearchAsyncClient;
import com.azure.search.documents.SearchClientBuilder;
import com.azure.search.documents.SearchServiceVersion;
import com.azure.search.documents.implementation.SearchIndexClientImpl;
import com.azure.search.documents.implementation.converters.IndexActionConverter;
import com.azure.search.documents.implementation.models.AutocompleteRequest;
import com.azure.search.documents.implementation.models.ErrorResponseException;
import com.azure.search.documents.implementation.models.IndexAction;
import com.azure.search.documents.implementation.models.SearchContinuationToken;
import com.azure.search.documents.implementation.models.SearchDocumentsResult;
import com.azure.search.documents.implementation.models.SearchFirstPageResponseWrapper;
import com.azure.search.documents.implementation.models.SearchRequest;
import com.azure.search.documents.implementation.models.SuggestDocumentsResult;
import com.azure.search.documents.implementation.models.SuggestRequest;
import com.azure.search.documents.implementation.util.Utility;
import com.azure.search.documents.indexes.models.IndexDocumentsBatch;
import com.azure.search.documents.models.AutocompleteOptions;
import com.azure.search.documents.models.AutocompleteResult;
import com.azure.search.documents.models.IndexActionType;
import com.azure.search.documents.models.IndexDocumentsOptions;
import com.azure.search.documents.models.IndexDocumentsResult;
import com.azure.search.documents.models.SearchOptions;
import com.azure.search.documents.models.SearchResult;
import com.azure.search.documents.models.SuggestOptions;
import com.azure.search.documents.models.SuggestResult;
import com.azure.search.documents.util.AutocompletePagedIterable;
import com.azure.search.documents.util.AutocompletePagedResponse;
import com.azure.search.documents.util.SearchPagedIterable;
import com.azure.search.documents.util.SearchPagedResponse;
import com.azure.search.documents.util.SuggestPagedIterable;
import com.azure.search.documents.util.SuggestPagedResponse;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@ServiceClient(builder=SearchClientBuilder.class)
public final class SearchClient {
    private static final ClientLogger LOGGER = new ClientLogger(SearchClient.class);
    private final SearchServiceVersion serviceVersion;
    private final String endpoint;
    private final String indexName;
    private final SearchIndexClientImpl restClient;
    private final HttpPipeline httpPipeline;
    final JsonSerializer serializer;

    SearchClient(String endpoint, String indexName, SearchServiceVersion serviceVersion, HttpPipeline httpPipeline, JsonSerializer serializer, SearchIndexClientImpl restClient) {
        this.endpoint = endpoint;
        this.indexName = indexName;
        this.serviceVersion = serviceVersion;
        this.httpPipeline = httpPipeline;
        this.serializer = serializer;
        this.restClient = restClient;
    }

    public String getIndexName() {
        return this.indexName;
    }

    HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IndexDocumentsResult uploadDocuments(Iterable<?> documents) {
        return (IndexDocumentsResult)this.uploadDocumentsWithResponse(documents, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IndexDocumentsResult> uploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return this.indexDocumentsWithResponse(SearchAsyncClient.buildIndexBatch(documents, IndexActionType.UPLOAD), options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IndexDocumentsResult mergeDocuments(Iterable<?> documents) {
        return (IndexDocumentsResult)this.mergeDocumentsWithResponse(documents, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IndexDocumentsResult> mergeDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return this.indexDocumentsWithResponse(SearchAsyncClient.buildIndexBatch(documents, IndexActionType.MERGE), options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IndexDocumentsResult mergeOrUploadDocuments(Iterable<?> documents) {
        return (IndexDocumentsResult)this.mergeOrUploadDocumentsWithResponse(documents, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IndexDocumentsResult> mergeOrUploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return this.indexDocumentsWithResponse(SearchAsyncClient.buildIndexBatch(documents, IndexActionType.MERGE_OR_UPLOAD), options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IndexDocumentsResult deleteDocuments(Iterable<?> documents) {
        return (IndexDocumentsResult)this.deleteDocumentsWithResponse(documents, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IndexDocumentsResult> deleteDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return this.indexDocumentsWithResponse(SearchAsyncClient.buildIndexBatch(documents, IndexActionType.DELETE), options, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public IndexDocumentsResult indexDocuments(IndexDocumentsBatch<?> batch) {
        return (IndexDocumentsResult)this.indexDocumentsWithResponse(batch, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IndexDocumentsResult> indexDocumentsWithResponse(IndexDocumentsBatch<?> batch, IndexDocumentsOptions options, Context context) {
        List<IndexAction> indexActions = batch.getActions().stream().map(document -> IndexActionConverter.map(document, (ObjectSerializer)this.serializer)).collect(Collectors.toList());
        boolean throwOnAnyError = options == null || options.throwOnAnyError();
        return Utility.indexDocumentsWithResponse(this.restClient, indexActions, throwOnAnyError, context, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> T getDocument(String key, Class<T> modelClass) {
        return (T)this.getDocumentWithResponse(key, modelClass, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Response<T> getDocumentWithResponse(String key, Class<T> modelClass, List<String> selectedFields, Context context) {
        try {
            Response<Map<String, Object>> response = this.restClient.getDocuments().getWithResponse(key, selectedFields, null, context);
            return new SimpleResponse(response, this.serializer.deserializeFromBytes(this.serializer.serializeToBytes(response.getValue()), TypeReference.createInstance(modelClass)));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)Utility.mapErrorResponseException(ex)));
        }
        catch (RuntimeException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public long getDocumentCount() {
        return (Long)this.getDocumentCountWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Long> getDocumentCountWithResponse(Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> this.restClient.getDocuments().countWithResponse(null, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SearchPagedIterable search(String searchText) {
        return this.search(searchText, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SearchPagedIterable search(String searchText, SearchOptions searchOptions, Context context) {
        SearchRequest request = SearchAsyncClient.createSearchRequest(searchText, searchOptions);
        SearchFirstPageResponseWrapper firstPageResponseWrapper = new SearchFirstPageResponseWrapper();
        Function<String, SearchPagedResponse> func = continuationToken -> this.search(request, (String)continuationToken, firstPageResponseWrapper, context);
        return new SearchPagedIterable(() -> (SearchPagedResponse)((Object)((Object)func.apply(null))), func);
    }

    private SearchPagedResponse search(SearchRequest request, String continuationToken, SearchFirstPageResponseWrapper firstPageResponseWrapper, Context context) {
        if (continuationToken == null && firstPageResponseWrapper.getFirstPageResponse() != null) {
            return firstPageResponseWrapper.getFirstPageResponse();
        }
        SearchRequest requestToUse = continuationToken == null ? request : SearchContinuationToken.deserializeToken(this.serviceVersion.getVersion(), continuationToken);
        return Utility.executeRestCallWithExceptionHandling(() -> {
            Response<SearchDocumentsResult> response = this.restClient.getDocuments().searchPostWithResponse(requestToUse, null, context);
            SearchDocumentsResult result = (SearchDocumentsResult)response.getValue();
            SearchPagedResponse page = new SearchPagedResponse((Response<List<SearchResult>>)new SimpleResponse(response, SearchAsyncClient.getSearchResults(result, this.serializer)), SearchAsyncClient.createContinuationToken(result, this.serviceVersion), result.getFacets(), result.getCount(), result.getCoverage(), result.getAnswers(), result.getSemanticPartialResponseReason(), result.getSemanticPartialResponseType());
            if (continuationToken == null) {
                firstPageResponseWrapper.setFirstPageResponse(page);
            }
            return page;
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SuggestPagedIterable suggest(String searchText, String suggesterName) {
        return this.suggest(searchText, suggesterName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SuggestPagedIterable suggest(String searchText, String suggesterName, SuggestOptions suggestOptions, Context context) {
        SuggestRequest suggestRequest = SearchAsyncClient.createSuggestRequest(searchText, suggesterName, Utility.ensureSuggestOptions(suggestOptions));
        return new SuggestPagedIterable(() -> this.suggest(suggestRequest, context));
    }

    private SuggestPagedResponse suggest(SuggestRequest suggestRequest, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> {
            Response<SuggestDocumentsResult> response = this.restClient.getDocuments().suggestPostWithResponse(suggestRequest, null, context);
            SuggestDocumentsResult result = (SuggestDocumentsResult)response.getValue();
            return new SuggestPagedResponse((Response<List<SuggestResult>>)new SimpleResponse(response, SearchAsyncClient.getSuggestResults(result, this.serializer)), result.getCoverage());
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public AutocompletePagedIterable autocomplete(String searchText, String suggesterName) {
        return this.autocomplete(searchText, suggesterName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public AutocompletePagedIterable autocomplete(String searchText, String suggesterName, AutocompleteOptions autocompleteOptions, Context context) {
        AutocompleteRequest request = SearchAsyncClient.createAutoCompleteRequest(searchText, suggesterName, autocompleteOptions);
        return new AutocompletePagedIterable(() -> this.autocomplete(request, context));
    }

    private AutocompletePagedResponse autocomplete(AutocompleteRequest request, Context context) {
        return Utility.executeRestCallWithExceptionHandling(() -> {
            Response<AutocompleteResult> response = this.restClient.getDocuments().autocompletePostWithResponse(request, null, context);
            return new AutocompletePagedResponse((SimpleResponse<AutocompleteResult>)new SimpleResponse(response, (Object)((AutocompleteResult)response.getValue())));
        }, LOGGER);
    }
}

