/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.search.documents.implementation.converters.IndexActionHelper;
import com.azure.search.documents.models.IndexAction;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;

public final class IndexActionConverter {
    public static <T> IndexAction<T> map(com.azure.search.documents.implementation.models.IndexAction obj) {
        if (obj == null) {
            return null;
        }
        IndexAction indexAction = new IndexAction();
        indexAction.setActionType(obj.getActionType());
        if (obj.getAdditionalProperties() != null) {
            Map<String, Object> properties = obj.getAdditionalProperties();
            IndexActionHelper.setProperties(indexAction, properties);
        }
        return indexAction;
    }

    public static <T> com.azure.search.documents.implementation.models.IndexAction map(IndexAction<T> obj, ObjectSerializer serializer) {
        byte[] documentJson;
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.implementation.models.IndexAction indexAction = new com.azure.search.documents.implementation.models.IndexAction().setActionType(obj.getActionType());
        Map<String, Object> document = IndexActionHelper.getProperties(obj);
        if (document == null) {
            document = obj.getDocument();
        }
        if ((documentJson = serializer.serializeToBytes(document)) != null) {
            try (JsonReader reader = JsonProviders.createReader((byte[])documentJson);){
                indexAction.setAdditionalProperties(reader.readMap(JsonReader::readUntyped));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return indexAction;
    }

    private IndexActionConverter() {
    }
}

