/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchIndex;
import java.io.IOException;
import java.util.List;

public final class ListIndexesResult
implements JsonSerializable<ListIndexesResult> {
    private final List<SearchIndex> indexes;

    public ListIndexesResult(List<SearchIndex> indexes) {
        this.indexes = indexes;
    }

    public List<SearchIndex> getIndexes() {
        return this.indexes;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ListIndexesResult fromJson(JsonReader jsonReader) throws IOException {
        return (ListIndexesResult)jsonReader.readObject(reader -> {
            boolean indexesFound = false;
            List indexes = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    indexes = reader.readArray(reader1 -> SearchIndex.fromJson(reader1));
                    indexesFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (indexesFound) {
                return new ListIndexesResult(indexes);
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}

