/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.VectorSearchCompression;
import com.azure.search.documents.indexes.models.VectorSearchCompressionKind;
import java.io.IOException;

public final class BinaryQuantizationCompression
extends VectorSearchCompression {
    private VectorSearchCompressionKind kind = VectorSearchCompressionKind.BINARY_QUANTIZATION;

    public BinaryQuantizationCompression(String compressionName) {
        super(compressionName);
    }

    @Override
    public VectorSearchCompressionKind getKind() {
        return this.kind;
    }

    @Override
    public BinaryQuantizationCompression setRerankWithOriginalVectors(Boolean rerankWithOriginalVectors) {
        super.setRerankWithOriginalVectors(rerankWithOriginalVectors);
        return this;
    }

    @Override
    public BinaryQuantizationCompression setDefaultOversampling(Double defaultOversampling) {
        super.setDefaultOversampling(defaultOversampling);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getCompressionName());
        jsonWriter.writeBooleanField("rerankWithOriginalVectors", this.isRerankWithOriginalVectors());
        jsonWriter.writeNumberField("defaultOversampling", (Number)this.getDefaultOversampling());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static BinaryQuantizationCompression fromJson(JsonReader jsonReader) throws IOException {
        return (BinaryQuantizationCompression)jsonReader.readObject(reader -> {
            boolean compressionNameFound = false;
            String compressionName = null;
            Boolean rerankWithOriginalVectors = null;
            Double defaultOversampling = null;
            VectorSearchCompressionKind kind = VectorSearchCompressionKind.BINARY_QUANTIZATION;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    compressionName = reader.getString();
                    compressionNameFound = true;
                    continue;
                }
                if ("rerankWithOriginalVectors".equals(fieldName)) {
                    rerankWithOriginalVectors = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("defaultOversampling".equals(fieldName)) {
                    defaultOversampling = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorSearchCompressionKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (compressionNameFound) {
                BinaryQuantizationCompression deserializedBinaryQuantizationCompression = new BinaryQuantizationCompression(compressionName);
                deserializedBinaryQuantizationCompression.setRerankWithOriginalVectors(rerankWithOriginalVectors);
                deserializedBinaryQuantizationCompression.setDefaultOversampling(defaultOversampling);
                deserializedBinaryQuantizationCompression.kind = kind;
                return deserializedBinaryQuantizationCompression;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

