/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.models.SearchIndexerSkill;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class DocumentExtractionSkill
extends SearchIndexerSkill {
    private String odataType = "#Microsoft.Skills.Util.DocumentExtractionSkill";
    private String parsingMode;
    private String dataToExtract;
    private Map<String, Object> configuration;

    public DocumentExtractionSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public String getParsingMode() {
        return this.parsingMode;
    }

    public DocumentExtractionSkill setParsingMode(String parsingMode) {
        this.parsingMode = parsingMode;
        return this;
    }

    public String getDataToExtract() {
        return this.dataToExtract;
    }

    public DocumentExtractionSkill setDataToExtract(String dataToExtract) {
        this.dataToExtract = dataToExtract;
        return this;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public DocumentExtractionSkill setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
        return this;
    }

    @Override
    public DocumentExtractionSkill setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public DocumentExtractionSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public DocumentExtractionSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", this.getInputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.getOutputs(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("context", this.getContext());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("parsingMode", this.parsingMode);
        jsonWriter.writeStringField("dataToExtract", this.dataToExtract);
        jsonWriter.writeMapField("configuration", this.configuration, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentExtractionSkill fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentExtractionSkill)jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List inputs = null;
            boolean outputsFound = false;
            List outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String odataType = "#Microsoft.Skills.Util.DocumentExtractionSkill";
            String parsingMode = null;
            String dataToExtract = null;
            Map configuration = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = reader.getString();
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                if ("parsingMode".equals(fieldName)) {
                    parsingMode = reader.getString();
                    continue;
                }
                if ("dataToExtract".equals(fieldName)) {
                    dataToExtract = reader.getString();
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    configuration = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            if (inputsFound && outputsFound) {
                DocumentExtractionSkill deserializedDocumentExtractionSkill = new DocumentExtractionSkill(inputs, outputs);
                deserializedDocumentExtractionSkill.setName(name);
                deserializedDocumentExtractionSkill.setDescription(description);
                deserializedDocumentExtractionSkill.setContext(context);
                deserializedDocumentExtractionSkill.odataType = odataType;
                deserializedDocumentExtractionSkill.parsingMode = parsingMode;
                deserializedDocumentExtractionSkill.dataToExtract = dataToExtract;
                deserializedDocumentExtractionSkill.configuration = configuration;
                return deserializedDocumentExtractionSkill;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

