/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SearchIndexerDataContainer
implements JsonSerializable<SearchIndexerDataContainer> {
    private final String name;
    private String query;

    public SearchIndexerDataContainer(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getQuery() {
        return this.query;
    }

    public SearchIndexerDataContainer setQuery(String query) {
        this.query = query;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("query", this.query);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerDataContainer fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerDataContainer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String query = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("query".equals(fieldName)) {
                    query = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                SearchIndexerDataContainer deserializedSearchIndexerDataContainer = new SearchIndexerDataContainer(name);
                deserializedSearchIndexerDataContainer.query = query;
                return deserializedSearchIndexerDataContainer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}

