// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Defines options to control Cross-Origin Resource Sharing (CORS) for an index.
 */
@Fluent
public final class CorsOptions implements JsonSerializable<CorsOptions> {
    /*
     * The list of origins from which JavaScript code will be granted access to your index. Can contain a list of hosts
     * of the form {protocol}://{fully-qualified-domain-name}[:{port#}], or a single '*' to allow all origins (not
     * recommended).
     */
    private final List<String> allowedOrigins;

    /*
     * The duration for which browsers should cache CORS preflight responses. Defaults to 5 minutes.
     */
    private Long maxAgeInSeconds;

    /**
     * Creates an instance of CorsOptions class.
     * 
     * @param allowedOrigins the allowedOrigins value to set.
     */
    public CorsOptions(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    /**
     * Get the allowedOrigins property: The list of origins from which JavaScript code will be granted access to your
     * index. Can contain a list of hosts of the form {protocol}://{fully-qualified-domain-name}[:{port#}], or a single
     * '*' to allow all origins (not recommended).
     * 
     * @return the allowedOrigins value.
     */
    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    /**
     * Get the maxAgeInSeconds property: The duration for which browsers should cache CORS preflight responses. Defaults
     * to 5 minutes.
     * 
     * @return the maxAgeInSeconds value.
     */
    public Long getMaxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    /**
     * Set the maxAgeInSeconds property: The duration for which browsers should cache CORS preflight responses. Defaults
     * to 5 minutes.
     * 
     * @param maxAgeInSeconds the maxAgeInSeconds value to set.
     * @return the CorsOptions object itself.
     */
    public CorsOptions setMaxAgeInSeconds(Long maxAgeInSeconds) {
        this.maxAgeInSeconds = maxAgeInSeconds;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedOrigins", this.allowedOrigins,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("maxAgeInSeconds", this.maxAgeInSeconds);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CorsOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CorsOptions if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CorsOptions.
     */
    public static CorsOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean allowedOriginsFound = false;
            List<String> allowedOrigins = null;
            Long maxAgeInSeconds = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowedOrigins".equals(fieldName)) {
                    allowedOrigins = reader.readArray(reader1 -> reader1.getString());
                    allowedOriginsFound = true;
                } else if ("maxAgeInSeconds".equals(fieldName)) {
                    maxAgeInSeconds = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }
            if (allowedOriginsFound) {
                CorsOptions deserializedCorsOptions = new CorsOptions(allowedOrigins);
                deserializedCorsOptions.maxAgeInSeconds = maxAgeInSeconds;

                return deserializedCorsOptions;
            }
            throw new IllegalStateException("Missing required property: allowedOrigins");
        });
    }
}
